/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.resource;

import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ArrecadacaoBairroDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ArrecadacaoDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.InadimplenciaDTO;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.ArrecadacaoParams;
import br.com.elotech.portaltransparencia.aiseportal.service.ArrecadacaoService;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/arrecadacoes"})
public class ArrecadacaoResource {
    private final ArrecadacaoService service;

    public ArrecadacaoResource(ArrecadacaoService service) {
        this.service = service;
    }

    @GetMapping(params={"entidade", "exercicio"})
    public ResponseEntity<List<ArrecadacaoDTO>> findReceitasArrecadacao(ArrecadacaoParams params) {
        return ResponseEntity.ok((Object)this.service.findReceitasArrecadacao(params));
    }

    @GetMapping(value={"/inadimplencia"}, params={"entidade", "exercicio"})
    public ResponseEntity<InadimplenciaDTO> loadValorInadimplencia(ArrecadacaoParams params) {
        return ResponseEntity.ok((Object)this.service.loadValoresInadimplencia(params));
    }

    @GetMapping(value={"/bairros"}, params={"entidade", "exercicio", "receita", "bairro"})
    public ResponseEntity<List<ArrecadacaoBairroDTO>> findReceitasArrecadacaoPorBairros(ArrecadacaoParams params) {
        return ResponseEntity.ok((Object)this.service.findReceitasArrecadacaoPorBairros(params));
    }
}

