/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.UltimaAtualizacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.service.UltimaAtualizacaoService;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ultimas-atualizacoes"})
public class UltimaAtualizacaoResource {
    private final UltimaAtualizacaoService ultimaAtualizacaoService;

    public UltimaAtualizacaoResource(UltimaAtualizacaoService ultimaAtualizacaoService) {
        this.ultimaAtualizacaoService = ultimaAtualizacaoService;
    }

    @GetMapping
    public ResponseEntity<List<UltimaAtualizacaoDTO>> ultimasAtualizacoes() {
        return ResponseEntity.ok((Object)this.ultimaAtualizacaoService.findUltimasAtualizacoes());
    }

    @GetMapping(value={"/by-table"}, params={"modulo", "table", "column", "filtrarEntidade"})
    public ResponseEntity<UltimaAtualizacaoDTO> getUltimaAtualizacaoByTableAndColumn(String modulo, String table, String column, Boolean filtrarEntidade, @RequestHeader(value="entidade") Long entidade) {
        Long entidadeFiltrar = null;
        if (filtrarEntidade.booleanValue()) {
            entidadeFiltrar = entidade;
        }
        UltimaAtualizacaoDTO ultimaAtualizacao = this.ultimaAtualizacaoService.getUltimaAtualizacaoByTableAndColumn(modulo, table, column, entidadeFiltrar);
        ultimaAtualizacao.setModulo(modulo);
        return ResponseEntity.ok((Object)ultimaAtualizacao);
    }

    @GetMapping(value={"/consulta-atual"})
    public ResponseEntity<UltimaAtualizacaoDTO> getDataConsultaAtual() {
        UltimaAtualizacaoDTO dto = UltimaAtualizacaoDTO.builder().modulo(ModuloEnum.MODULO_OXY_FOLHA_PAGAMENTO.getValue()).ultimoAcesso(LocalDateTime.now()).build();
        return ResponseEntity.ok((Object)dto);
    }
}

