/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.AditivoConvenioDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ArquivoPessoalDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ConvenioDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.RepasseConvenioDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.ConvenioRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindConvenioParams;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ConvenioRepositoryImpl
implements ConvenioRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConvenioRepositoryImpl.class);
    private static final String CONVENIO = "db/sql/contab/convenio.sql";
    private static final String CONVENIO_ARQUIVOS = "db/sql/contab/convenio-arquivo.sql";
    private static final String CONVENIO_ADITIVOS = "db/sql/contab/convenio-aditivos.sql";
    private static final String CONVENIO_REPASSES = "db/sql/contab/convenio-repasses.sql";
    private static final String CONTRAPARTIDA = "db/sql/contab/contrapartida.sql";
    private static final String CONVENIO_PAGAMENTO = "db/sql/contab/convenio-pagamentos.sql";
    private final DatasourceWrapper datasourceWrapper;
    private final EntidadeContabilidadeService entidadeService;

    @Autowired
    public ConvenioRepositoryImpl(@Qualifier(value="wrapperContabilidade") DatasourceWrapper datasourceWrapper, EntidadeContabilidadeService entidadeService) {
        this.datasourceWrapper = datasourceWrapper;
        this.entidadeService = entidadeService;
    }

    public Page<ConvenioDTO> findConvenios(FindConvenioParams params, Pageable pageable) {
        String sql = FileUtils.readResourceAsString((String)CONVENIO);
        StringBuilder query = new StringBuilder();
        query.append(" SELECT X.* FROM ( ");
        query.append(sql);
        query.append(" AND A.ENTIDADE " + this.entidadeService.resolveWhereSQL(params.getEntidade()));
        params.getNrConvenio().ifPresent(item -> query.append(" AND A.NRCONVENIO = :nrConvenio "));
        params.getNrAnoConvenio().ifPresent(item -> query.append(" AND A.NRANOCONVENIO = :nrAnoConvenio "));
        params.getDestinatario().ifPresent(item -> query.append(" AND tiraacento(LOWER(B.NOME)) LIKE tiraacento(LOWER(:destinatario)) "));
        query.append(") X ");
        params.getSituacao().ifPresent(item -> query.append(" WHERE X.IDSITUACAO = :situacao "));
        String queryOrder = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)query.toString(), (String)" ORDER BY X.IDSITUACAO, X.ID DESC ");
        sql = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)queryOrder, (String)this.datasourceWrapper.getPlatform());
        this.consoleLogger(params, sql);
        MapSqlParameterSource parameter = params.toJdbcParameter();
        List list = this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)parameter, (RowMapper)new ElotechBeanPropertyRowMapper(ConvenioDTO.class));
        Long total = (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(this.getCount(query.toString()).toString(), (SqlParameterSource)parameter, Long.class);
        for (ConvenioDTO convenioDTO : list) {
            convenioDTO.setDisplayConvenio(String.format("%d/%d", convenioDTO.getNrConvenio(), convenioDTO.getNrAnoConvenio()));
        }
        return new PageImpl(list, pageable, total.longValue());
    }

    private void consoleLogger(FindConvenioParams params, String sql) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(sql);
            LOGGER.debug(params.toString());
        }
    }

    private StringBuilder getCount(String sql) {
        StringBuilder sqlCount = new StringBuilder();
        sqlCount.append("SELECT COUNT(*) AS TOTAL");
        sqlCount.append(" FROM (");
        sqlCount.append(sql);
        sqlCount.append(") X");
        return sqlCount;
    }

    public Optional<ConvenioDTO> findConvenio(FindConvenioParams params) {
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)CONVENIO));
        query.append(" AND A.ENTIDADE " + this.entidadeService.resolveWhereSQL(params.getEntidade()));
        query.append(" AND A.ID = :id ");
        query.append(" AND A.NRCONVENIO = :nrConvenio ");
        query.append(" AND A.NRANOCONVENIO = :nrAnoConvenio ");
        query.append(" ORDER BY A.ID DESC ");
        this.consoleLogger(params, query.toString());
        ElotechBeanPropertyRowMapper rowMapper = new ElotechBeanPropertyRowMapper(ConvenioDTO.class);
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)rowMapper).stream().findFirst();
    }

    public List<ArquivoPessoalDTO> findArquivos(FindConvenioParams params, String nomeSchemaEloArquivo) {
        String sql = FileUtils.readResourceAsString((String)CONVENIO_ARQUIVOS).replace("schema_eloarquivo", nomeSchemaEloArquivo);
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ArquivoPessoalDTO.class));
    }

    public List<RepasseConvenioDTO> findRepassesConvenio(FindConvenioParams params) {
        String sql = FileUtils.readResourceAsString((String)CONVENIO_REPASSES);
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(RepasseConvenioDTO.class));
    }

    public List<RepasseConvenioDTO> findContraPartida(FindConvenioParams params) {
        String sql = FileUtils.readResourceAsString((String)CONTRAPARTIDA);
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(RepasseConvenioDTO.class));
    }

    public List<AditivoConvenioDTO> findAditivos(FindConvenioParams params) {
        String sql = FileUtils.readResourceAsString((String)CONVENIO_ADITIVOS);
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(AditivoConvenioDTO.class));
    }

    public List<RepasseConvenioDTO> findPagamentosConvenio(FindConvenioParams params) {
        String sql = FileUtils.readResourceAsString((String)CONVENIO_PAGAMENTO);
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(RepasseConvenioDTO.class));
    }
}

