/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.admportal.repository.PortalParametroRepository;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.Parametro;
import br.com.elotech.portaltransparencia.contabportal.domain.PortalParametroContabil;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.AdiantamentoPessoalDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ArquivoPessoalDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.enums.ParametroEnum;
import br.com.elotech.portaltransparencia.contabportal.repository.AdiantamentoRepository;
import br.com.elotech.portaltransparencia.contabportal.repository.ParametroRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindPessoalParams;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class AdiantamentoRepositoryImpl
implements AdiantamentoRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdiantamentoRepositoryImpl.class);
    private static final String ADIANTAMENTOS_PRESTACAO_CONTAS = "db/sql/contab/adiantamento-prestacaocontas.sql";
    private static final String ADIANTAMENTOS = "db/sql/contab/adiantamento.sql";
    private static final String ARQUIVO_PRESTACAO_CONTAS = "db/sql/contab/arquivo-prestacaocontas.sql";
    private static final int MOSTRA_DIARIAS_ADIANTAMENTO = 128;
    private static final int MOSTRA_ADIANTAMENTO_CONTABILIZADO = 214;
    private final DatasourceWrapper datasourceWrapper;
    @Autowired
    private PortalParametroRepository portalparametrorepository;
    @Autowired
    private ParametroRepository parametroContabilRepository;
    @Autowired
    private EntidadeContabilidadeService entidadeService;

    @Autowired
    public AdiantamentoRepositoryImpl(@Qualifier(value="wrapperContabilidade") DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    private boolean mostraDiariasAdiantamento(FindPessoalParams params) {
        PortalParametroContabil paramContabil = this.portalparametrorepository.findOneByIdEntidadeAndIdExercicioAndIdId(this.entidadeService.getEntidadeSelecionada(params.getEntidade()).getId(), params.getExercicio(), Long.valueOf(128L));
        return paramContabil != null && "S".equals(paramContabil.getValor());
    }

    private String mostraAdiantamentoContabilizado(FindPessoalParams params) {
        PortalParametroContabil paramContabil = this.portalparametrorepository.findOneByIdEntidadeAndIdExercicioAndIdId(this.entidadeService.getEntidadeSelecionada(params.getEntidade()).getId(), params.getExercicio(), Long.valueOf(214L));
        if (paramContabil != null) {
            return paramContabil.getValor();
        }
        return "0";
    }

    public Page<AdiantamentoPessoalDTO> findAdiantamentos(FindPessoalParams params, Pageable pageable) {
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)ADIANTAMENTOS_PRESTACAO_CONTAS));
        this.filtros(params, query);
        params.getAnoSubvencao().ifPresent(item -> query.append(" AND A.ANOSUBVENCAO = :anoSubvencao "));
        params.getSubvencao().ifPresent(item -> query.append(" AND A.SUBVENCAO = :subvencao "));
        this.filtraContabilizado(params, query);
        query.append(" ) Y");
        this.unionAdiantamentos(params, query);
        StringBuilder sqlTotalRegistros = this.getCount(query.toString());
        String sql = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)query.toString(), (String)" ORDER BY 3 DESC ");
        sql = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)sql, (String)this.datasourceWrapper.getPlatform());
        this.consoleLogger(params, sql);
        MapSqlParameterSource parameter = params.toJdbcParameter();
        List list = this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(AdiantamentoPessoalDTO.class));
        Parametro paramContabil = this.parametroContabilRepository.findByEntidadeExercicioModuloAndCodigo(this.entidadeService.getEntidadeSelecionada(params.getEntidade()).getId(), params.getExercicio(), ModuloEnum.MODULO_SISCOP.getValue(), ParametroEnum.PARAM_PERMITE_EXCEDER_PRESTACAO_CONTAS.getCodigo());
        for (AdiantamentoPessoalDTO adiantamentoPessoalDTO : list) {
            adiantamentoPessoalDTO.setDisplayEmpenho(String.format("%d/%d", adiantamentoPessoalDTO.getEmpenho(), adiantamentoPessoalDTO.getExercicioEmpenho()));
            adiantamentoPessoalDTO.setPermiteExcederPrestacaoContas(paramContabil.getValor());
        }
        Long total = (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(sqlTotalRegistros.toString(), (SqlParameterSource)parameter, Long.class);
        return new PageImpl(list, pageable, total.longValue());
    }

    private void consoleLogger(FindPessoalParams params, String sql) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(sql);
            LOGGER.debug(params.toString());
        }
    }

    private void filtros(FindPessoalParams params, StringBuilder query) {
        params.getNome().ifPresent(item -> query.append(" AND tiraacento(LOWER(F.NOME)) LIKE tiraacento(LOWER(:nome)) "));
        params.getDataInicial().ifPresent(item -> query.append(" AND CAST(A.DATA AS DATE) >= :dataInicial "));
        params.getDataFinal().ifPresent(item -> query.append(" AND CAST(A.DATA AS DATE) <= :dataFinal "));
        if (!this.mostraDiariasAdiantamento(params)) {
            query.append(" AND SUBSTR(E.PROGRAMATICA,23,2) <> '14' ");
        }
        query.append(" AND A.ENTIDADE" + this.entidadeService.resolveWhereSQL(params.getEntidade()));
    }

    private StringBuilder getCount(String sql) {
        StringBuilder sqlCount = new StringBuilder();
        sqlCount.append("SELECT COUNT(*) AS TOTAL");
        sqlCount.append(" FROM (");
        sqlCount.append(sql);
        sqlCount.append(") X");
        return sqlCount;
    }

    public Optional<AdiantamentoPessoalDTO> findPrestacaoContas(FindPessoalParams params) {
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)ADIANTAMENTOS_PRESTACAO_CONTAS));
        if (!this.mostraDiariasAdiantamento(params)) {
            query.append(" AND SUBSTR(E.PROGRAMATICA,23,2) <> '14' ");
        }
        query.append(" AND A.ENTIDADE" + this.entidadeService.resolveWhereSQL(params.getEntidade()));
        query.append(" AND A.PRESTACAOCONTAS = :prestacaoContas) Y ");
        this.consoleLogger(params, query.toString());
        ElotechBeanPropertyRowMapper rowMapper = new ElotechBeanPropertyRowMapper(AdiantamentoPessoalDTO.class);
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)rowMapper).stream().findFirst();
    }

    public Optional<AdiantamentoPessoalDTO> findAdiantamento(FindPessoalParams params) {
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)ADIANTAMENTOS));
        if (!this.mostraDiariasAdiantamento(params)) {
            query.append(" AND SUBSTR(E.PROGRAMATICA,23,2) <> '14' ");
        }
        query.append(" AND A.EMPENHO = :empenho ");
        query.append(" AND A.NOLIQUIDACAO = :noLiquidacao ");
        query.append(" AND A.UNIDADEORCAMENTARIA = :unidadeOrcamentaria ");
        query.append(" AND A.MATRICULA = :matricula ");
        query.append(" AND A.ENTIDADE" + this.entidadeService.resolveWhereSQL(params.getEntidade()));
        this.consoleLogger(params, query.toString());
        ElotechBeanPropertyRowMapper rowMapper = new ElotechBeanPropertyRowMapper(AdiantamentoPessoalDTO.class);
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)rowMapper).stream().findFirst();
    }

    public AdiantamentoPessoalDTO findTotalAdiantamentos(FindPessoalParams params) {
        String sqlPrestacaoContas = FileUtils.readResourceAsString((String)ADIANTAMENTOS_PRESTACAO_CONTAS);
        StringBuilder query = new StringBuilder();
        query.append("SELECT COALESCE(SUM(X.VALORDOCUMENTOS), 0.0) AS VALORDOCUMENTOS,");
        query.append("       COALESCE(SUM(X.VALORRESTITUIDO), 0.0) AS VALORRESTITUIDO,");
        query.append("       COALESCE(SUM(X.VALOREMPENHO), 0.0) AS VALOREMPENHO");
        query.append(" FROM(   ");
        query.append(sqlPrestacaoContas);
        this.filtros(params, query);
        this.filtraContabilizado(params, query);
        query.append(" ) Y");
        this.unionAdiantamentos(params, query);
        query.append(") X ");
        this.consoleLogger(params, query.toString());
        ElotechBeanPropertyRowMapper rowMapper = new ElotechBeanPropertyRowMapper(AdiantamentoPessoalDTO.class);
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)rowMapper).stream().findFirst().orElse(new AdiantamentoPessoalDTO());
    }

    private void unionAdiantamentos(FindPessoalParams params, StringBuilder query) {
        query.append(" UNION ALL ");
        String sqlAdiantamentos = FileUtils.readResourceAsString((String)ADIANTAMENTOS);
        query.append(sqlAdiantamentos);
        this.filtros(params, query);
        params.getAnoSubvencao().ifPresent(item -> query.append(" AND E.ANOSUBVENCAO = :anoSubvencao "));
        params.getSubvencao().ifPresent(item -> query.append(" AND E.SUBVENCAO = :subvencao "));
    }

    public List<ArquivoPessoalDTO> findArquivos(FindPessoalParams params, String nomeSchemaEloArquivo) {
        String sql = FileUtils.readResourceAsString((String)ARQUIVO_PRESTACAO_CONTAS).replace("schema_eloarquivo", nomeSchemaEloArquivo);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(params.toString());
        }
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ArquivoPessoalDTO.class));
    }

    private void filtraContabilizado(FindPessoalParams params, StringBuilder query) {
        switch (this.mostraAdiantamentoContabilizado(params)) {
            case "0": {
                query.append(" AND A.CONTABILIZADO = 'S' ");
                break;
            }
            case "1": {
                query.append(" AND A.CONTABILIZADO = 'N' ");
                break;
            }
            default: {
                query.append("");
            }
        }
    }
}

