/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain.dto;

import br.com.elotech.contabilidade.client.dto.EmpenhoTotalDTO;
import br.com.elotech.contabilidade.client.dto.FornecedorMovimentacaoDTO;
import br.com.elotech.core.utils.NumberUtils;
import br.com.elotech.portaltransparencia.utils.MaskFormatterUtils;
import java.math.BigDecimal;
import java.util.Optional;
import lombok.Generated;

public class ComprasDiretaFornecedorDTO {
    private String nome;
    private String cnpjCpf;
    private Long fornecedor;
    private BigDecimal empenhado;
    private BigDecimal anulado;
    private BigDecimal liquidado;
    private BigDecimal retido;
    private BigDecimal pago;
    private BigDecimal aPagar;

    public ComprasDiretaFornecedorDTO(FornecedorMovimentacaoDTO fornecedor) {
        this.fornecedor = fornecedor.getId();
        this.nome = fornecedor.getNome();
        this.cnpjCpf = MaskFormatterUtils.getMaskFormatado((String)Optional.ofNullable(fornecedor.getCnpjCpf()).orElse(""), (String)"##.###.###/####-##");
        this.empenhado = fornecedor.getMovimentoAtePeriodo().getEmpenhado();
        this.anulado = fornecedor.getMovimentoAtePeriodo().getSaldoAnulado();
        this.liquidado = fornecedor.getMovimentoAtePeriodo().getSaldoLiquidacao();
        this.retido = fornecedor.getMovimentoAtePeriodo().getSaldoRetido();
        this.pago = fornecedor.getMovimentoAtePeriodo().getSaldoPago();
        this.aPagar = fornecedor.getMovimentoAtePeriodo().getEmpenhoPagar();
    }

    public ComprasDiretaFornecedorDTO(EmpenhoTotalDTO empenhoTotalOxy) {
        this.empenhado = empenhoTotalOxy.getMovimentoAtePeriodo().getEmpenhado();
        this.anulado = empenhoTotalOxy.getMovimentoAtePeriodo().getSaldoAnulado();
        this.liquidado = empenhoTotalOxy.getMovimentoAtePeriodo().getSaldoLiquidacao();
        this.retido = empenhoTotalOxy.getMovimentoAtePeriodo().getSaldoRetido();
        this.pago = empenhoTotalOxy.getMovimentoAtePeriodo().getSaldoPago();
        this.aPagar = empenhoTotalOxy.getMovimentoAtePeriodo().getEmpenhoPagar();
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getCnpjCpf() {
        return this.cnpjCpf;
    }

    public void setCnpjCpf(String cnpjCpf) {
        this.cnpjCpf = cnpjCpf;
    }

    public Long getFornecedor() {
        return this.fornecedor;
    }

    public void setFornecedor(Long fornecedor) {
        this.fornecedor = fornecedor;
    }

    public BigDecimal getEmpenhado() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.empenhado);
    }

    public void setEmpenhado(BigDecimal empenhado) {
        this.empenhado = empenhado;
    }

    public BigDecimal getAnulado() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.anulado);
    }

    public void setAnulado(BigDecimal anulado) {
        this.anulado = anulado;
    }

    public BigDecimal getLiquidado() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.liquidado);
    }

    public void setLiquidado(BigDecimal liquidado) {
        this.liquidado = liquidado;
    }

    public BigDecimal getRetido() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.retido);
    }

    public void setRetido(BigDecimal retido) {
        this.retido = retido;
    }

    public BigDecimal getPago() {
        return this.pago;
    }

    public void setPago(BigDecimal pago) {
        this.pago = pago;
    }

    public BigDecimal getaPagar() {
        return this.aPagar;
    }

    public void setaPagar(BigDecimal aPagar) {
        this.aPagar = aPagar;
    }

    @Generated
    public ComprasDiretaFornecedorDTO() {
    }
}

