SELECT S.ID,
       S.ENTIDADE,
       S.EXERCICIO,
       S.SUBVENCAO,
       S.ANOSUBVENCAO,
       S.FUNCAO,
       S.CARGAHORARIA,
       S.REMUNERACAO,
       S.PERIODO,
       S.TIPOPERIODO,
       S.PERIODO||' '||
       CASE S.TIPOPERIODO 
            WHEN 'A' THEN 'Ano(s)'
            WHEN 'M' THEN 'Mês(es)'
            WHEN 'S' THEN 'Semana(s)'
            ELSE 'NULL'
       END PERIODODESC,
       (S.REMUNERACAO * S.PERIODO) VALORTOTAL
  FROM SUBVENCAOREMUNERACAO S
 WHERE S.ENTIDADE     = :entidade
   AND S.EXERCICIO    = :exercicio
   AND S.SUBVENCAO    = :subvencao
   AND S.ANOSUBVENCAO = :anoSubvencao
 ORDER BY S.ID