/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.portaltransparencia.contabportal.domain.CentroCusto;
import br.com.elotech.portaltransparencia.contabportal.domain.PatrimonioBem;
import br.com.elotech.portaltransparencia.contabportal.domain.PatrimonioBemPK;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.LocalDate;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="PAT_VEICULO")
public class Veiculo
implements EloEntity<PatrimonioBemPK> {
    @EmbeddedId
    private PatrimonioBemPK id;
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="centrocusto", referencedColumnName="centrocusto"))})
    private CentroCusto centroCusto;
    @Length(max=20)
    private @Length(max=20) String chassi;
    @Length(max=254)
    private @Length(max=254) String descricao;
    @Length(max=3)
    private @Length(max=3) String letraPlaca;
    @Length(max=3)
    private @Length(max=3) String numeroPlaca;
    private Long renavan;
    @Length(max=1)
    private @Length(max=1) String baixado;
    @Column(name="DATAAQUISICAO")
    private LocalDate dataAquisicao;
    @NotNull
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="entidade", referencedColumnName="entidade", insertable=false, updatable=false), @JoinColumn(name="tipo", referencedColumnName="tipo", insertable=false, updatable=false), @JoinColumn(name="bem", referencedColumnName="bem", insertable=false, updatable=false), @JoinColumn(name="chapa", referencedColumnName="chapa", insertable=false, updatable=false)})
    @JsonIgnore
    @NotFound(action=NotFoundAction.IGNORE)
    private PatrimonioBem bem;

    @Generated
    public String toString() {
        return "Veiculo(id=" + this.getId() + ", descricao=" + this.getDescricao() + ", letraPlaca=" + this.getLetraPlaca() + ", numeroPlaca=" + this.getNumeroPlaca() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Veiculo)) {
            return false;
        }
        Veiculo other = (Veiculo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        PatrimonioBemPK this$id = this.getId();
        PatrimonioBemPK other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Veiculo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PatrimonioBemPK $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public Veiculo() {
    }

    @Generated
    public PatrimonioBemPK getId() {
        return this.id;
    }

    @Generated
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    @Generated
    public String getChassi() {
        return this.chassi;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public String getLetraPlaca() {
        return this.letraPlaca;
    }

    @Generated
    public String getNumeroPlaca() {
        return this.numeroPlaca;
    }

    @Generated
    public Long getRenavan() {
        return this.renavan;
    }

    @Generated
    public String getBaixado() {
        return this.baixado;
    }

    @Generated
    public LocalDate getDataAquisicao() {
        return this.dataAquisicao;
    }

    @Generated
    public PatrimonioBem getBem() {
        return this.bem;
    }

    @Generated
    public void setId(PatrimonioBemPK id) {
        this.id = id;
    }

    @Generated
    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    @Generated
    public void setChassi(String chassi) {
        this.chassi = chassi;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setLetraPlaca(String letraPlaca) {
        this.letraPlaca = letraPlaca;
    }

    @Generated
    public void setNumeroPlaca(String numeroPlaca) {
        this.numeroPlaca = numeroPlaca;
    }

    @Generated
    public void setRenavan(Long renavan) {
        this.renavan = renavan;
    }

    @Generated
    public void setBaixado(String baixado) {
        this.baixado = baixado;
    }

    @Generated
    public void setDataAquisicao(LocalDate dataAquisicao) {
        this.dataAquisicao = dataAquisicao;
    }

    @Generated
    public void setBem(PatrimonioBem bem) {
        this.bem = bem;
    }
}

