/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.comprasportal.repository.NadItemPercentualRepository;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoItensDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoItensPercDTO;
import br.com.elotech.portaltransparencia.web.rest.params.EmpenhoItensPercParams;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class NadItemPercentualRepositoryImpl
implements NadItemPercentualRepository {
    private static final String EMPENHOITENSPERC = "db/sql/contab/empenhoItensPerc.sql";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public NadItemPercentualRepositoryImpl(@Qualifier(value="wrapperCompras") DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public List<EmpenhoItensPercDTO> getEmpenhoDetalheItensPerc(EmpenhoItensDTO item) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)EMPENHOITENSPERC));
        try {
            EmpenhoItensPercParams params = new EmpenhoItensPercParams(item.getEntidade(), item.getAnoNad(), item.getNoNad(), item.getOrdemNadItemPerc());
            return this.datasourceWrapper.getJdbcTemplate().query(sql.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(EmpenhoItensPercDTO.class));
        }
        catch (InvalidDataAccessApiUsageException e) {
            return new ArrayList<EmpenhoItensPercDTO>();
        }
    }
}

