/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.protocportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.repository.PortalParametroRepository;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.PortalParametroContabil;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import br.com.elotech.portaltransparencia.protocportal.dto.EstatisticaDTO;
import br.com.elotech.portaltransparencia.protocportal.dto.SerieItemDTO;
import br.com.elotech.portaltransparencia.protocportal.repository.EstatisticaRepository;
import br.com.elotech.portaltransparencia.protocportal.repository.impl.PessoaRepositoryImpl;
import br.com.elotech.portaltransparencia.protocportal.resource.params.EstatisticaParams;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class EstatisticaRepositoryImpl
implements EstatisticaRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(PessoaRepositoryImpl.class);
    private static final String MEDIA_RESPOSTAS_ORACLE = "db/sql/protoc/media-respostas-estatistica-oracle.sql";
    private static final String MEDIA_RESPOSTAS_POSTGRES = "db/sql/protoc/media-respostas-estatistica-postgres.sql";
    private static final String ESTATISTICAS = "db/sql/protoc/estatisticas.sql";
    private static final String PROCESSOS_POR_SEXO = "db/sql/protoc/ProcessosPorSexo.sql";
    private static final String PROCESSOS_POR_IDADE = "db/sql/protoc/ProcessosPorIdade.sql";
    private static final String PROCESSOS_POR_ESCOLARIDADE = "db/sql/protoc/ProcessosPorEscolaridade.sql";
    private final DatasourceWrapper datasourceWrapper;
    private final EntidadeContabilidadeService entidadeService;
    private final PortalParametroRepository portalParametroRepository;

    @Autowired
    public EstatisticaRepositoryImpl(@Qualifier(value="wrapperProtocolo") DatasourceWrapper datasourceWrapper, EntidadeContabilidadeService entidadeService, PortalParametroRepository portalParametroRepository) {
        this.datasourceWrapper = datasourceWrapper;
        this.entidadeService = entidadeService;
        this.portalParametroRepository = portalParametroRepository;
    }

    public Optional<Long> getEntidadeProtocolo(Long entidade) {
        Long entidadeProtocolo = 0L;
        if (entidade > 0L) {
            PortalParametroContabil parametro = this.portalParametroRepository.findOneByIdEntidadeAndIdExercicioAndIdId(entidade, Parametros.NAO_DEPENDE_EXERCICIO, Parametros.PARAM_ENTIDADE_PROTOCOLO);
            if (Objects.nonNull(parametro) && StringUtils.isNotBlank((String)parametro.getValor())) {
                entidadeProtocolo = Long.parseLong(parametro.getValor());
            }
            if (entidadeProtocolo <= 0L && Objects.nonNull(parametro = this.portalParametroRepository.findOneByIdEntidadeAndIdExercicioAndIdId(this.entidadeService.getEntidadePrincipal().orElse(new Entidade()).getId(), Parametros.NAO_DEPENDE_EXERCICIO, Parametros.PARAM_ENTIDADE_PROTOCOLO)) && StringUtils.isNotBlank((String)parametro.getValor())) {
                entidadeProtocolo = Long.parseLong(parametro.getValor());
            }
        }
        if (entidadeProtocolo <= 0L) {
            return Optional.empty();
        }
        return Optional.of(entidadeProtocolo);
    }

    public BigDecimal getMediaResposta(EstatisticaParams params) {
        StringBuilder query = new StringBuilder(this.getSQL());
        params.getExercicio().ifPresent(item -> query.append(" AND A.ANO = :exercicio "));
        this.getEntidadeProtocolo(params.getEntidade().orElse(0L)).ifPresent(item -> query.append(" AND A.ENTIDADE = " + item));
        this.consoleLogger(query);
        BigDecimal result = (BigDecimal)this.datasourceWrapper.getJdbcTemplate().queryForObject(query.toString(), (SqlParameterSource)params.toJdbcParameter(), BigDecimal.class);
        return result.setScale(2, 4);
    }

    private void consoleLogger(StringBuilder query) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(query.toString());
        }
    }

    public List<EstatisticaDTO> findEstatisticas(EstatisticaParams params) {
        String sql = FileUtils.readResourceAsString((String)ESTATISTICAS);
        StringBuilder filtro = new StringBuilder();
        params.getExercicio().ifPresent(item -> filtro.append(" AND E.EXERCICIO = :exercicio "));
        this.getEntidadeProtocolo(params.getEntidade().orElse(0L)).ifPresent(item -> filtro.append(" AND E.ENTIDADE = " + item));
        StringBuilder query = new StringBuilder(sql.replace("$[FILTRO]", filtro.toString()));
        this.consoleLogger(query);
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(EstatisticaDTO.class));
    }

    private String getSQL() {
        if (SqlUtils.isPostgres((String)this.datasourceWrapper.getPlatform())) {
            return FileUtils.readResourceAsString((String)MEDIA_RESPOSTAS_POSTGRES);
        }
        return FileUtils.readResourceAsString((String)MEDIA_RESPOSTAS_ORACLE);
    }

    public List<SerieItemDTO> findProcessosPorGenero(EstatisticaParams params) {
        String sql = FileUtils.readResourceAsString((String)PROCESSOS_POR_SEXO);
        StringBuilder filtro = new StringBuilder();
        this.getEntidadeProtocolo(params.getEntidade().orElse(0L)).ifPresent(item -> filtro.append(" AND ENTIDADE = " + item));
        sql = sql.replace("$[FILTRO]", filtro.toString());
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (RowMapper)new ElotechBeanPropertyRowMapper(SerieItemDTO.class));
    }

    public List<SerieItemDTO> findProcessosPorIdade(EstatisticaParams params) {
        String sql = FileUtils.readResourceAsString((String)PROCESSOS_POR_IDADE);
        StringBuilder filtro = new StringBuilder();
        this.getEntidadeProtocolo(params.getEntidade().orElse(0L)).ifPresent(item -> filtro.append(" AND P.ENTIDADE = " + item));
        sql = sql.replace("$[FILTRO]", filtro.toString());
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (RowMapper)new ElotechBeanPropertyRowMapper(SerieItemDTO.class));
    }

    public List<SerieItemDTO> findProcessosPorEscolaridade(EstatisticaParams params) {
        String sql = FileUtils.readResourceAsString((String)PROCESSOS_POR_ESCOLARIDADE);
        StringBuilder filtro = new StringBuilder();
        this.getEntidadeProtocolo(params.getEntidade().orElse(0L)).ifPresent(item -> filtro.append(" AND P.ENTIDADE = " + item));
        sql = sql.replace("$[FILTRO]", filtro.toString());
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (RowMapper)new ElotechBeanPropertyRowMapper(SerieItemDTO.class));
    }
}

