/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.h2;

import br.com.elotech.core.utils.DateUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public final class Function {
    private static final String DIREITA = "D";
    private static final String ESQUERDA = "E";

    private Function() {
    }

    public static Date inicioCompetencia(int ano, int mes) {
        LocalDate localDate = LocalDate.of(ano, mes, 1);
        return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static Date fimCompetencia(int ano, int mes) {
        LocalDate endOfMonth = YearMonth.of(ano, mes).atEndOfMonth();
        return Date.from(endOfMonth.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static BigDecimal getSalarioFuncionario(int entidade, int matricula, int mesCompetencia, int anoCompetencia) {
        return BigDecimal.TEN;
    }

    public static String tiraAcento(String texto) {
        return br.com.elotech.core.utils.StringUtils.retiraAcentos((String)texto);
    }

    public static String completaString(String texto, String caracter, String direcao, int qtde) {
        if (direcao.equals(ESQUERDA)) {
            return StringUtils.leftPad((String)texto, (int)qtde, (String)caracter);
        }
        if (direcao.equals(DIREITA)) {
            return StringUtils.rightPad((String)texto, (int)qtde, (String)caracter);
        }
        return texto;
    }

    public static String getNumeroFaixa(String faixa, String padraoNivelInicial) {
        return "N-160";
    }

    public static String getTipoFolhaPrincipal(String entidade) {
        return "1";
    }

    public static BigDecimal getSalarioFuncPortal(int entidade, int matricula, int mesCompetencia, int anoCompetencia, int tipoFolha, Date competenciaLancamento) {
        return BigDecimal.TEN;
    }

    public static String blobToVarchar(String texto) {
        return texto;
    }

    public static int buscaAno(String data) {
        LocalDate date = LocalDate.parse(data);
        return date.getYear();
    }

    public static Long dateMinus(Date date, Date dateCompare) {
        return ChronoUnit.DAYS.between(DateUtils.toLocalDate((Date)dateCompare), DateUtils.toLocalDate((Date)date));
    }
}

