SELECT X.ENTIDADE, X.EXERCICIO, X.RECEITA, X.DESCRICAO, X.NIVEL, X.INICIO, X.TAMANHO, X.ACEITAMOVIMENTACAO, 
       X.VALORORCADO,
       (SELECT SUM(VALORORCADO)
          FROM RECEITA
         WHERE ENTIDADE = X.ENTIDADE
           AND EXERCICIO = X.EXERCICIO
           AND SUBSTR(RECEITA,1, INICIO+TAMANHO-1) = X.RECEITA
           AND IDTIPOOPERACAORECEITA <> 1) AS VALORDEDUCAOINICIAL,
       X.VALORATUALIZADO,
       X.VALORARRECADADO,
       X.VALORDEDUCAO,
       X.VALORREALIZADOLIQUIDO 
FROM
(SELECT A.ENTIDADE, A.EXERCICIO, SUBSTR(A.RECEITA,1, A.INICIO+A.TAMANHO-1) AS RECEITA, A.DESCRICAO, A.NIVEL, A.INICIO, A.TAMANHO, A.MOVSN AS ACEITAMOVIMENTACAO, 
       SUM(A.VALORORCADO) AS VALORORCADO,
       SUM(A.VALORORCADO) + SUM(RECEITAMENSAL.VALORCORRECAOORCADO) AS VALORATUALIZADO,
       SUM(RECEITAMENSAL.VALORARRECADADO - RECEITAMENSAL.VALORESTARRECADADO - RECEITAMENSAL.VALORDEVOLUCAO + RECEITAMENSAL.VALORESTDEVOLUCAO) AS VALORARRECADADO,
       SUM(RECEITAMENSAL.VALORDEDUCAO) AS VALORDEDUCAO,
       SUM(RECEITAMENSAL.VALORREALIZADOLIQUIDO) AS VALORREALIZADOLIQUIDO
  FROM RECEITA A
  LEFT JOIN (SELECT ENTIDADE, EXERCICIO, RECEITA, FONTERECURSO, IDTIPOOPERACAORECEITA,
                    SUM(VALORARRECADADO)     AS VALORARRECADADO,
                    SUM(VALORDEVOLUCAO)      AS VALORDEVOLUCAO,
                    SUM(VALORESTARRECADADO)  AS VALORESTARRECADADO,
                    SUM(VALORESTDEVOLUCAO)   AS VALORESTDEVOLUCAO,
                    SUM(VALORCORRECAOORCADO) AS VALORCORRECAOORCADO,
                    SUM(VALORCORRECAO)       AS VALORCORRECAO,
                    SUM(VALORDEDUCAO)        AS VALORDEDUCAO,
                    SUM(VALORARRECADADO - VALORESTARRECADADO - VALORDEVOLUCAO + VALORESTDEVOLUCAO) AS VALORREALIZADO,
                    SUM(VALORARRECADADO - VALORESTARRECADADO - VALORDEVOLUCAO + VALORESTDEVOLUCAO - VALORDEDUCAO) AS VALORREALIZADOLIQUIDO
               FROM RECEITAMENSAL
              WHERE ENTIDADE = :entidade
                AND EXERCICIO = :exercicio
                AND MES <= 12
              GROUP BY ENTIDADE, EXERCICIO, RECEITA, FONTERECURSO, IDTIPOOPERACAORECEITA) RECEITAMENSAL
    ON A.ENTIDADE     = RECEITAMENSAL.ENTIDADE
   AND A.EXERCICIO    = RECEITAMENSAL.EXERCICIO
   AND A.RECEITA      = RECEITAMENSAL.RECEITA
   AND A.FONTERECURSO = RECEITAMENSAL.FONTERECURSO
   AND A.IDTIPOOPERACAORECEITA = RECEITAMENSAL.IDTIPOOPERACAORECEITA
 WHERE A.EXERCICIO = :exercicio
   AND A.ENTIDADE = :entidade
   AND A.IDTIPOOPERACAORECEITA = 1
 GROUP BY A.ENTIDADE, A.EXERCICIO, SUBSTR(A.RECEITA,1, A.INICIO+A.TAMANHO-1), A.DESCRICAO, A.NIVEL, A.INICIO, A.TAMANHO, A.MOVSN, CASE WHEN A.IDTIPOOPERACAORECEITA = 1 THEN 'R' ELSE 'D' END, A.DESCRICAO
 ORDER BY SUBSTR(A.RECEITA,1, A.INICIO+A.TAMANHO-1)
)X
