SELECT DISTINCT I.DATAVALIDADE, 
       TCM.AREAUTILIZADA, 
       TCM.ATIVIDADEPRINCIPAL, 
       I.NUMERODOCUMENTO AS NUMEROALVARA,
       I.IDCADASTROGERALIMAGEM AS IDARQUIVO,
       I.MIMETYPE AS EXTENSAO,
       I.TIPODOCUMENTO
  FROM TRIBCADASTROMOBILIARIO TCM 
  JOIN TRIBCADASTROGERAL TCG 
    ON TCM.TIPOCADASTRO = TCG.TIPOCADASTRO
   AND TCM.CADASTROGERAL = TCG.CADASTROGERAL
  JOIN PESSOA P 
    ON TCG.PESSOA = P.PESSOA
  LEFT JOIN TRIBCADASTROGERALIMAGEM I
    ON I.TIPOCADASTRO = TCG.TIPOCADASTRO
   AND I.CADASTROGERAL = TCG.CADASTROGERAL
   AND I.PESSOA = P.PESSOA
 WHERE TCM.ENTIDADE = :entidade
   AND P.PESSOA = :pessoa
AND COALESCE(I.DATAVALIDADE, CURRENT_DATE) >= TRUNC(CURRENT_DATE)
 ORDER BY I.DATAVALIDADE
