/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.validation.EloViolation;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.MovimentacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.MovimentacaoRepository;
import br.com.elotech.portaltransparencia.web.rest.params.PesquisaMovimentacaoParams;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class MovimentacaoService {
    private final MovimentacaoRepository movimentacaoRepository;

    public MovimentacaoService(MovimentacaoRepository movimentacaoRepository) {
        this.movimentacaoRepository = movimentacaoRepository;
    }

    public List<MovimentacaoDTO> findMovimentacoes(PesquisaMovimentacaoParams params) {
        this.validarParametros(params);
        return this.movimentacaoRepository.findMovimentacoes(params);
    }

    private void validarParametros(PesquisaMovimentacaoParams params) {
        List violations = this.validarParametrosPesquisaMovimentacao(params);
        if (!violations.isEmpty()) {
            throw new EloValidationException("Campos n\u00e3o informados.", violations);
        }
    }

    protected List<EloViolation> validarParametrosPesquisaMovimentacao(PesquisaMovimentacaoParams params) {
        ArrayList violations = Lists.newArrayList();
        if (params.getEntidade() == null) {
            violations.add(new EloViolation("A Entidade n\u00e3o foi informada"));
        }
        if (params.getExercicio() == null) {
            violations.add(new EloViolation("A Exercicio n\u00e3o foi informado"));
        }
        if (params.getCentroCusto() == null) {
            violations.add(new EloViolation("O Centro de Custo n\u00e3o foi informado"));
        }
        return violations;
    }
}

