/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.portaltransparencia.contabportal.domain.ConfiguracaoInterface;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.QEntidade;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.portaltransparencia.contabportal.service.ConfiguracaoService;
import br.com.elotech.portaltransparencia.contabportal.service.RegistroService;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EntidadeContabilidadeService {
    private final ConfiguracaoService configuracaoService;
    private final EntidadeContabilidadeRepository entidadeRepository;
    private final RegistroService registroService;

    @Autowired
    public EntidadeContabilidadeService(EntidadeContabilidadeRepository entidadeRepository, ConfiguracaoService configuracaoService, RegistroService registroService) {
        this.configuracaoService = configuracaoService;
        this.entidadeRepository = entidadeRepository;
        this.registroService = registroService;
    }

    public Optional<Entidade> getEntidadePrincipal() {
        List entidades = this.getEntidades();
        Optional<Entidade> entidadePrincipal = entidades.stream().filter(e -> e.getId().equals(e.getEntidadePrincipal())).findFirst();
        if (entidadePrincipal.isPresent()) {
            return entidadePrincipal;
        }
        return entidades.stream().findFirst();
    }

    public String resolveWhereSQL(Long entidade) {
        if (entidade > 0L) {
            return " = " + entidade;
        }
        Optional<ConfiguracaoInterface> configuracao = Optional.ofNullable(this.configuracaoService.getConfiguracao());
        if (configuracao.isPresent()) {
            return " NOT IN (" + configuracao.get().getNaoMostrarEntidade() + ")";
        }
        return "";
    }

    public Entidade getEntidadeSelecionada(Long idEntidade) {
        if (idEntidade > 0L) {
            return this.findOne(idEntidade);
        }
        return this.getEntidadePrincipal().orElse(null);
    }

    public Boolean verificaRegistro(Entidade entidade) {
        return this.registroService.isValid("34", entidade.getNome());
    }

    public List<Entidade> getEntidades() {
        ArrayList entidadesHabilitadas = Lists.newArrayList((Iterable)this.entidadeRepository.findAll((Predicate)QEntidade.entidade.id.notIn((Collection)this.idsEntidadesNaoHabilitadasPortal())));
        entidadesHabilitadas.stream().forEach(e -> e.setRegistrado(this.verificaRegistro(e).booleanValue()));
        Entidade entidadeConsolidada = new Entidade(Long.valueOf(-1L));
        entidadeConsolidada.setNome("CONSOLIDADA");
        entidadesHabilitadas.add(entidadeConsolidada);
        return entidadesHabilitadas;
    }

    private List<Long> idsEntidadesNaoHabilitadasPortal() {
        Optional<ConfiguracaoInterface> configuracao = Optional.ofNullable(this.configuracaoService.getConfiguracao());
        if (configuracao.isPresent() && !StringUtils.isEmpty((String)configuracao.get().getNaoMostrarEntidade())) {
            return Arrays.asList(configuracao.get().getNaoMostrarEntidade().split(",")).stream().map(String::trim).map(Long::parseLong).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }

    public Entidade findOne(Long id) {
        return (Entidade)this.entidadeRepository.findOne((Object)id);
    }

    public Integer getTamanhoReceita(Long entidade, Long exercicio) {
        return this.entidadeRepository.getTamanhoReceita(entidade, exercicio);
    }

    public String getUf(Long entidade) {
        return this.entidadeRepository.getUf(entidade);
    }

    public boolean isHabilitadoPortal(Long entidade) {
        return this.idsEntidadesNaoHabilitadasPortal().stream().filter(id -> id.equals(entidade)).count() == 0L;
    }

    public List<Entidade> findAll() {
        return this.entidadeRepository.findAll().stream().map(e -> {
            e.setHabilitadoPortal(this.isHabilitadoPortal(e.getId()));
            return e;
        }).collect(Collectors.toList());
    }
}

