/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.repository.PortalParametroRepository;
import br.com.elotech.portaltransparencia.contabportal.domain.PortalParametroContabil;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.MensagemDTO;
import br.com.elotech.portaltransparencia.contabportal.service.MensagemService;
import br.com.elotech.portaltransparencia.protocportal.resource.ProcessoResource;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.mail.MailException;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/mensagens"})
public class MensagemResource {
    private final Logger log = LoggerFactory.getLogger(ProcessoResource.class);
    private final MensagemService mensagemService;
    private final PortalParametroRepository portalParametroRepository;

    public MensagemResource(MensagemService mensagemService, PortalParametroRepository portalParametroRepository) {
        this.mensagemService = mensagemService;
        this.portalParametroRepository = portalParametroRepository;
    }

    @PostMapping
    public ResponseEntity<Boolean> enviarMensagem(@RequestBody MensagemDTO mensagem, @RequestParam(value="entidade") Long entidade) throws InterruptedException, ExecutionException {
        try {
            String toAddresses = mensagem.getEmail().concat(",").concat(this.getOuvidoriaEmail());
            Boolean done = (Boolean)this.mensagemService.enviarMensagem(mensagem, toAddresses, entidade).get();
            return ResponseEntity.ok((Object)done);
        }
        catch (MailException e) {
            this.log.error("Falha no envio de email", (Throwable)e);
            return ResponseEntity.ok((Object)false);
        }
    }

    private String getOuvidoriaEmail() {
        PortalParametroContabil email = this.portalParametroRepository.findOneByIdEntidadeAndIdExercicioAndIdId(Parametros.NAO_DEPENDE_ENTIDADE, Parametros.NAO_DEPENDE_EXERCICIO, Parametros.PARAM_ATENDIMENTO_EMAIL);
        return email.getValor();
    }
}

