/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.service.PortalParametroService;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ArquivoPessoalDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.DiariaPessoalDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.TipoObjetivoDiariaDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindPessoalParams;
import br.com.elotech.portaltransparencia.contabportal.service.DiariaService;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/diarias"})
public class DiariaResource {
    private final DiariaService diariaService;
    private final PortalParametroService portalParametroService;
    private final BaseExport baseExport;
    private final ElotechProperties elotechProperties;
    private final EntidadeContabilidadeRepository entidadeRepository;
    private final EntidadeContabilidadeService entidadeService;

    public DiariaResource(DiariaService diariaService, PortalParametroService portalParametroService, BaseExport baseExport, ElotechProperties elotechProperties, EntidadeContabilidadeRepository entidadeRepository, EntidadeContabilidadeService entidadeService) {
        this.diariaService = diariaService;
        this.portalParametroService = portalParametroService;
        this.baseExport = baseExport;
        this.elotechProperties = elotechProperties;
        this.entidadeRepository = entidadeRepository;
        this.entidadeService = entidadeService;
    }

    @GetMapping
    public ResponseEntity<Page<DiariaPessoalDTO>> findDiarias(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, FindPessoalParams params, Pageable pageable) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.diariaService.findDiarias(params, pageable));
    }

    @GetMapping(value={"/diariasWithoutQuantidade"})
    public ResponseEntity<List<DiariaPessoalDTO>> findDiariasWithoutQuantidade(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, FindPessoalParams params) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.diariaService.findDiariasWithoutQuantidade(params));
    }

    @GetMapping(value={"/report"})
    public ModelAndView findDiariasExport(HttpServletRequest request, HttpServletResponse response, FindPessoalParams params, Pageable pageable) throws Throwable {
        PageRequest pageRequest = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros(), (Sort)pageable.getSort());
        Page diariasPage = this.diariaService.findDiarias(params, (Pageable)pageRequest);
        Entidade entidadeObj = (Entidade)this.entidadeRepository.findOne((Object)this.entidadeService.getEntidadeSelecionada(params.getEntidade()).getId());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setReportTitle("Di\u00e1rias");
        reportParam.setClazzDTO(DiariaPessoalDTO.class);
        String headerFields = "Entidade,Empenho,Nome,Data Sa\u00edda,Data Retorno,Destino,Qtde,M\u00e9dio ou Unit\u00e1rio,Valor Total,Valor Anulado";
        String fields = "entidade,displayEmpenho,nome,displayDataSaida,displayDataRetorno,destino,quantidadeDiarias,valorUnitario,valorDiarias,valorAnulado";
        float[] fieldsPerc = new float[]{1.0f, 1.0f, 2.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
        if (this.mostrarSecretaria() && this.mostrarCargo()) {
            headerFields = "Entidade,Empenho,Nome,Cargo/Matricula,Secretaria,Data Sa\u00edda e Retorno,Destino,Qtde,Unit\u00e1rio,Valor Total,Valor Anulado";
            fields = "entidade,displayEmpenho,nome,cargo,secretaria,displayDataSaidaRetorno,destino,quantidadeDiarias,valorUnitario,valorDiarias,valorAnulado";
            fieldsPerc = new float[]{1.0f, 1.0f, 2.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
        } else if (this.mostrarSecretaria()) {
            headerFields = "Entidade,Empenho,Nome,Secretaria,Data Sa\u00edda,Data Retorno,Destino,Qtde,Unit\u00e1rio,Valor Total,Valor Anulado";
            fields = "entidade,displayEmpenho,nome,secretaria,displayDataSaida,displayDataRetorno,destino,quantidadeDiarias,valorUnitario,valorDiarias,valorAnulado";
            fieldsPerc = new float[]{1.0f, 1.0f, 2.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
        } else if (this.mostrarCargo()) {
            headerFields = "Entidade,Empenho,Nome,Cargo/Matricula,Data Sa\u00edda,Data Retorno,Destino,Qtde,Unit\u00e1rio,Valor Total,Valor Anulado";
            fields = "entidade,displayEmpenho,nome,cargo,displayDataSaida,displayDataRetorno,destino,quantidadeDiarias,valorUnitario,valorDiarias,valorAnulado";
            fieldsPerc = new float[]{1.0f, 1.0f, 2.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
        }
        reportParam.setHeaderFields(headerFields);
        reportParam.setFields(fields);
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{15, 15, 100, 50, 20, 10, 20, 50, 20, 20, 20};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setSumFields("valorDiarias");
        reportParam.setPage(diariasPage);
        reportParam.setFontSize(6.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }

    private boolean mostrarCargo() {
        String paramMostrarCargo = this.portalParametroService.getPortalParametroValor(Parametros.NAO_DEPENDE_ENTIDADE, Parametros.NAO_DEPENDE_EXERCICIO, Parametros.PARAM_MOSTRA_CARGO_DIARIA);
        return SimNao.toBoolean((String)paramMostrarCargo);
    }

    private boolean mostrarSecretaria() {
        String paramMostrarSecretaria = this.portalParametroService.getPortalParametroValor(Parametros.NAO_DEPENDE_ENTIDADE, Parametros.NAO_DEPENDE_EXERCICIO, Parametros.PARAM_MOSTRA_SECRETARIA_DIRIA);
        return SimNao.toBoolean((String)paramMostrarSecretaria);
    }

    @GetMapping(value={"/total"})
    public ResponseEntity<DiariaPessoalDTO> findTotalDiarias(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, FindPessoalParams params) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.diariaService.findTotalDiarias(params));
    }

    @GetMapping(params={"entidade", "exercicio", "empenho", "noLiquidacao", "unidadeOrcamentaria"})
    public ResponseEntity<DiariaPessoalDTO> findDiaria(FindPessoalParams params) {
        return this.diariaService.findDiaria(params).map(ResponseEntity::ok).orElseThrow(() -> RestException.notFound((String)"N\u00e3o foi poss\u00edvel encontrar esta di\u00e1ria."));
    }

    @GetMapping(value={"/arquivos"}, params={"entidade", "exercicio", "empenho", "noLiquidacao"})
    public ResponseEntity<List<ArquivoPessoalDTO>> findArquivos(FindPessoalParams params) {
        return ResponseEntity.ok((Object)this.diariaService.findArquivos(params));
    }

    @GetMapping(value={"/objetivos-diaria"})
    public ResponseEntity<List<TipoObjetivoDiariaDTO>> getTiposObjetivoDiaria() {
        return ResponseEntity.ok((Object)this.diariaService.getTiposObjetivoDiaria());
    }
}

