/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ArquivoPessoalDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.AudienciasPublicasDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.AudienciasPublicasParams;
import br.com.elotech.portaltransparencia.contabportal.service.AudienciasPublicasService;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/audiencias-publicas"})
public class AudienciasPublicasResource {
    private final AudienciasPublicasService audienciasPublicasService;
    private final BaseExport baseExport;
    private final EntidadeContabilidadeRepository entidadeRepository;
    private final ElotechProperties elotechProperties;

    @Autowired
    public AudienciasPublicasResource(AudienciasPublicasService audienciasPublicasService, BaseExport baseExport, EntidadeContabilidadeRepository entidadeRepository, ElotechProperties elotechProperties) {
        this.audienciasPublicasService = audienciasPublicasService;
        this.baseExport = baseExport;
        this.entidadeRepository = entidadeRepository;
        this.elotechProperties = elotechProperties;
    }

    @GetMapping
    public ResponseEntity<Page<AudienciasPublicasDTO>> getAudienciasPublicas(Pageable pageable, AudienciasPublicasParams params) {
        return ResponseEntity.ok((Object)this.audienciasPublicasService.getAudienciasPublicas(pageable, params));
    }

    @GetMapping(value={"/detalhes"}, params={"entidade", "exercicio", "id"})
    public ResponseEntity<AudienciasPublicasDTO> getAudienciasPublicasDetalhes(AudienciasPublicasParams params) {
        return ResponseEntity.ok((Object)this.audienciasPublicasService.getAudienciasPublicasDetalhes(params));
    }

    @GetMapping(value={"/report"})
    public ModelAndView getAudienciasPublicasExport(HttpServletRequest request, HttpServletResponse response, @Valid AudienciasPublicasParams params, Pageable pageable) throws Throwable {
        params.setExercicio(params.getExercicio());
        PageRequest pageRequest = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros(), (Sort)pageable.getSort());
        Page page = this.audienciasPublicasService.getAudienciasPublicas((Pageable)pageRequest, params);
        Entidade entidadeObj = (Entidade)this.entidadeRepository.findOne((Object)params.getEntidade());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setReportTitle("Audi\u00eancias P\u00fablicas");
        reportParam.setClazzDTO(AudienciasPublicasDTO.class);
        reportParam.setHeaderFields("Natureza,Tipo,Data,Local,Forma Chamamento");
        reportParam.setFields("descNatureza,descTipo,data,local,chamamento");
        float[] fieldsPerc = new float[]{2.0f, 2.0f, 0.5f, 2.0f, 0.7f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{30, 10, 10, 500, 15};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setPage(page);
        reportParam.setFontSize(6.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }

    @GetMapping(value={"/arquivos"}, params={"entidade", "exercicio", "id"})
    public ResponseEntity<List<ArquivoPessoalDTO>> findArquivos(AudienciasPublicasParams params) {
        return ResponseEntity.ok((Object)this.audienciasPublicasService.findArquivos(params));
    }
}

