/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ProgramaticaFilterDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.ProgramaticaRepository;
import br.com.elotech.portaltransparencia.web.rest.params.ProgramaticaParams;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ProgramaticaRepositoryImpl
implements ProgramaticaRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProgramaticaRepositoryImpl.class);
    private static final String PROGRAMATICAORGAO = "db/sql/contab/programatica-orgao.sql";
    private static final String PROGRAMATICAUNIDADE = "db/sql/contab/programatica-unidade.sql";
    private static final String PROGRAMATICAFUNCAO = "db/sql/contab/programatica-funcao.sql";
    private static final String PROGRAMATICASUBFUNCAO = "db/sql/contab/programatica-subFuncao.sql";
    private static final String PROGRAMATICAPROGRAMA = "db/sql/contab/programatica-programa.sql";
    private static final String PROGRAMATICAPROJETO = "db/sql/contab/programatica-projeto.sql";
    private static final String PROGRAMATICAELEMENTO = "db/sql/contab/programatica-elemento.sql";
    private static final String PROGRAMATICADESDOBRAMENTO = "db/sql/contab/programatica-desdobramento.sql";
    private static final String PROGRAMATICASUBDESDOBRAMENTO = "db/sql/contab/programatica-subDesdobramento.sql";
    private final NamedParameterJdbcTemplate jdbcTemplate;

    @Autowired
    public ProgramaticaRepositoryImpl(@Qualifier(value="dataSource") DataSource dataSource) {
        this.jdbcTemplate = new NamedParameterJdbcTemplate(dataSource);
    }

    public List<ProgramaticaFilterDTO> orgao(ProgramaticaParams params) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)PROGRAMATICAORGAO));
        sql.append(params.montaFiltro(ProgramaticaParams.ORG));
        LOGGER.debug(params.toString());
        return this.jdbcTemplate.query(sql.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ProgramaticaFilterDTO.class));
    }

    public List<ProgramaticaFilterDTO> unidade(ProgramaticaParams params) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)PROGRAMATICAUNIDADE));
        sql.append(params.montaFiltro(ProgramaticaParams.UNI));
        LOGGER.debug(params.toString());
        return this.jdbcTemplate.query(sql.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ProgramaticaFilterDTO.class));
    }

    public List<ProgramaticaFilterDTO> funcao(ProgramaticaParams params) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)PROGRAMATICAFUNCAO));
        sql.append(params.montaFiltro(ProgramaticaParams.FUN));
        LOGGER.debug(params.toString());
        return this.jdbcTemplate.query(sql.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ProgramaticaFilterDTO.class));
    }

    public List<ProgramaticaFilterDTO> subFuncao(ProgramaticaParams params) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)PROGRAMATICASUBFUNCAO));
        sql.append(params.montaFiltro(ProgramaticaParams.SFU));
        LOGGER.debug(params.toString());
        return this.jdbcTemplate.query(sql.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ProgramaticaFilterDTO.class));
    }

    public List<ProgramaticaFilterDTO> programa(ProgramaticaParams params) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)PROGRAMATICAPROGRAMA));
        sql.append(params.montaFiltro(ProgramaticaParams.PRO));
        LOGGER.debug(params.toString());
        return this.jdbcTemplate.query(sql.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ProgramaticaFilterDTO.class));
    }

    public List<ProgramaticaFilterDTO> projeto(ProgramaticaParams params) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)PROGRAMATICAPROJETO));
        sql.append(params.montaFiltro(ProgramaticaParams.PRJ));
        LOGGER.debug(params.toString());
        return this.jdbcTemplate.query(sql.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ProgramaticaFilterDTO.class));
    }

    public List<ProgramaticaFilterDTO> elemento(ProgramaticaParams params) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)PROGRAMATICAELEMENTO));
        sql.append(params.montaFiltro(ProgramaticaParams.ELE));
        LOGGER.debug(params.toString());
        return this.jdbcTemplate.query(sql.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ProgramaticaFilterDTO.class));
    }

    public List<ProgramaticaFilterDTO> desdobramento(ProgramaticaParams params) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)PROGRAMATICADESDOBRAMENTO));
        sql.append(params.montaFiltro(ProgramaticaParams.DES));
        LOGGER.debug(params.toString());
        return this.jdbcTemplate.query(sql.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ProgramaticaFilterDTO.class));
    }

    public List<ProgramaticaFilterDTO> subDesdobramento(ProgramaticaParams params) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)PROGRAMATICASUBDESDOBRAMENTO));
        sql.append(params.montaFiltro(ProgramaticaParams.SDE));
        LOGGER.debug(params.toString());
        return this.jdbcTemplate.query(sql.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ProgramaticaFilterDTO.class));
    }
}

