/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.MovimentacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.MovimentacaoRepository;
import br.com.elotech.portaltransparencia.web.rest.params.PesquisaMovimentacaoParams;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class MovimentacaoRepositoryImpl
implements MovimentacaoRepository {
    private static final String MOVIMENTACAO_SQL = "db/sql/contab/movimentacao.sql";
    private final DatasourceWrapper datasourceWrapper;

    public MovimentacaoRepositoryImpl(@Qualifier(value="wrapperContabilidade") DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public List<MovimentacaoDTO> findMovimentacoes(PesquisaMovimentacaoParams params) {
        String sql = FileUtils.readResourceAsString((String)MOVIMENTACAO_SQL);
        MapSqlParameterSource parameter = params.toJdbcParameter();
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)parameter, (RowMapper)new ElotechBeanPropertyRowMapper(MovimentacaoDTO.class));
    }
}

