/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeCustomRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class EntidadeContabilidadeRepositoryImpl
implements EntidadeContabilidadeCustomRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntidadeContabilidadeRepositoryImpl.class);
    private static final String TAMANHO_RECEITA = "db/sql/contab/tamanho-receita.sql";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public EntidadeContabilidadeRepositoryImpl(@Qualifier(value="wrapperContabilidade") DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public Integer getTamanhoReceita(Long entidade, Long exercicio) {
        String sql = FileUtils.readResourceAsString((String)TAMANHO_RECEITA);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("entidade", (Object)entidade, 2);
        params.addValue("exercicio", (Object)exercicio, 2);
        LOGGER.debug(sql);
        return (Integer)this.datasourceWrapper.getJdbcTemplate().queryForObject(sql, (SqlParameterSource)params, Integer.class);
    }

    public String getUf(Long entidade) {
        String sql = "SELECT uf FROM entidade WHERE entidade = :entidade";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("entidade", (Object)entidade, 2);
        LOGGER.debug(sql);
        return (String)this.datasourceWrapper.getJdbcTemplate().queryForObject(sql, (SqlParameterSource)params, String.class);
    }
}

