/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.resource;

import br.com.elotech.portaltransparencia.aiseportal.domain.dto.EstagiarioDTO;
import br.com.elotech.portaltransparencia.aiseportal.service.EstagiarioService;
import br.com.elotech.portaltransparencia.web.rest.params.ServidorParams;
import java.util.Optional;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/estagiarios"})
public class EstagiarioResource {
    private final EstagiarioService estagiarioService;

    @Autowired
    public EstagiarioResource(EstagiarioService estagiarioService) {
        this.estagiarioService = estagiarioService;
    }

    @GetMapping(value={"/{codigo}"})
    public ResponseEntity<EstagiarioDTO> getEstagiario(@PathVariable Long codigo, @RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid ServidorParams servidorParams) {
        servidorParams.setEntidade(entidade);
        servidorParams.setExercicio(exercicio);
        servidorParams.setCodigo(codigo);
        Optional servidor = this.estagiarioService.loadEstagiario(servidorParams);
        if (servidor.isPresent()) {
            return ResponseEntity.ok(servidor.get());
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping
    public ResponseEntity<Page<EstagiarioDTO>> loadServidores(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid ServidorParams estagiariosParams, Pageable pageable) {
        estagiariosParams.setEntidade(entidade);
        estagiariosParams.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.estagiarioService.loadEstagiarios(estagiariosParams, pageable));
    }

    @GetMapping(value={"/{vinculo}/{codigo}"})
    public ResponseEntity<EstagiarioDTO> getEstagiarioPorVinculo(@PathVariable String vinculo, @PathVariable Long codigo, @RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid ServidorParams servidorParams) {
        servidorParams.setEntidade(entidade);
        servidorParams.setExercicio(exercicio);
        servidorParams.setMatricula(codigo);
        servidorParams.setVinculo(vinculo);
        Optional servidor = this.estagiarioService.loadEstagiario(servidorParams);
        if (servidor.isPresent()) {
            return ResponseEntity.ok(servidor.get());
        }
        return ResponseEntity.notFound().build();
    }
}

