SELECT COUNT(TB1.VALUE) AS VALUE, TB1.LABEL
  FROM ( SELECT COUNT(NUMERO) AS VALUE,
           CASE WHEN P.DATANASCIMENTO IS NULL THEN 'Não Informado'
                WHEN TRUNC((P.DATAPROCESSO - P.DATANASCIMENTO)/ 365.25) <= 20 THEN 'Até 20 anos'
                WHEN TRUNC((P.DATAPROCESSO - P.DATANASCIMENTO)/ 365.25) <= 30 THEN 'De 21 a 30 anos'
                WHEN TRUNC((P.DATAPROCESSO - P.DATANASCIMENTO)/ 365.25) <= 40 THEN 'De 31 a 40 anos'
                WHEN TRUNC((P.DATAPROCESSO - P.DATANASCIMENTO)/ 365.25) <= 50 THEN 'De 41 a 50 anos'
                WHEN TRUNC((P.DATAPROCESSO - P.DATANASCIMENTO)/ 365.25) <= 60 THEN 'De 51 a 60 anos'
                WHEN TRUNC((P.DATAPROCESSO - P.DATANASCIMENTO)/ 365.25) > 60 THEN 'Acima de 60 anos'
            END AS LABEL
  FROM PROCESSOS P
 WHERE P.USUARIOREG = 'e-SIC'
 GROUP BY P.DATANASCIMENTO, P.DATAPROCESSO
) TB1 GROUP BY LABEL
