SELECT
  F.ENTIDADE,  
  TRIM(P.NOME) AS NOME,  
  F.MATRICULA,  
      (SELECT CASE
          WHEN SF.SITUACAO = 1 THEN 'ATIVO'
          WHEN SF.SITUACAO = 2 AND (EXISTS ( SELECT DISTINCT MA.ENTIDADE
             FROM RHMOVIMENTACAOAFASTAMENTO MA
            WHERE MA.ENTIDADE = SF.ENTIDADE AND MA.MATRICULA = SF.MATRICULA AND MA.DATAINICIAL = (( SELECT MAX(MA_1.DATAINICIAL) AS DATAINICIAL
                     FROM RHMOVIMENTACAOAFASTAMENTO MA_1
                    WHERE MA_1.ENTIDADE = SF.ENTIDADE AND MA_1.MATRICULA = SF.MATRICULA AND (MA_1.DATAFINAL >= FIMCOMPETENCIA(SF.ANOCOMPETENCIA, 12) OR MA_1.DATAFINAL IS NULL))))) THEN (('AFASTADO - ' || COALESCE(( SELECT A.DESCRICAO
             FROM RHAFASTAMENTO A
            WHERE A.ENTIDADE = SF.ENTIDADE AND A.AFASTAMENTO = (( SELECT MAX(MA.AFASTAMENTO) AS MAX
                     FROM RHMOVIMENTACAOAFASTAMENTO MA
                    WHERE MA.ENTIDADE = SF.ENTIDADE AND MA.MATRICULA = SF.MATRICULA AND MA.DATAINICIAL = (( SELECT MAX(MA_1.DATAINICIAL) AS DATAINICIAL
                             FROM RHMOVIMENTACAOAFASTAMENTO MA_1
                            WHERE MA_1.ENTIDADE = SF.ENTIDADE AND MA_1.MATRICULA = SF.MATRICULA AND (MA_1.DATAFINAL >= FIMCOMPETENCIA(SF.ANOCOMPETENCIA, 12) OR MA_1.DATAFINAL IS NULL)))))), ' ')) || ' ') || COALESCE(( SELECT DISTINCT 'LICENÇA PRÊMIO' AS TEXT
             FROM RHPROGRAMACAOPREMIO A
            WHERE A.ENTIDADE = SF.ENTIDADE AND A.MATRICULA = SF.MATRICULA AND A.FIMPECUNIA >= FIMCOMPETENCIA(SF.ANOCOMPETENCIA, 12) AND A.INICIOPECUNIA <= FIMCOMPETENCIA(SF.ANOCOMPETENCIA, 12) AND (A.FIMGOZO >= FIMCOMPETENCIA(SF.ANOCOMPETENCIA, 12) OR A.FIMGOZO IS NULL AND A.INICIOGOZO IS NOT NULL)), ' ')
          WHEN SF.SITUACAO = 3 AND (EXISTS ( SELECT MP.ENTIDADE
             FROM RHMOVIMENTACAOPESSOAL MP
               JOIN RHPROGRAMACAORESCISAO PR ON MP.ENTIDADE = PR.ENTIDADE AND MP.MATRICULA = PR.MATRICULA AND MP.MOVIMENTACAO = PR.MOVIMENTACAO
               JOIN RHRESCISAO R ON PR.ENTIDADE = R.ENTIDADE AND PR.RESCISAO = R.RESCISAO AND PR.CLASSE = R.CLASSE
            WHERE MP.ENTIDADE = SF.ENTIDADE AND MP.MATRICULA = SF.MATRICULA AND MP.TIPOMOVIMENTACAO = 7 AND (R.MOTIVO NOT IN (70, 71, 72, 73, 74, 75, 76, 77, 78, 79)))) THEN 'EXONERADO'
          WHEN SF.SITUACAO = 3 AND (EXISTS ( SELECT MP.ENTIDADE
             FROM RHMOVIMENTACAOPESSOAL MP
               LEFT JOIN RHPROGRAMACAORESCISAO PR ON MP.ENTIDADE = PR.ENTIDADE AND MP.MATRICULA = PR.MATRICULA AND MP.MOVIMENTACAO = PR.MOVIMENTACAO
               LEFT JOIN RHRESCISAO R ON PR.ENTIDADE = R.ENTIDADE AND PR.RESCISAO = R.RESCISAO AND PR.CLASSE = R.CLASSE
            WHERE MP.ENTIDADE = SF.ENTIDADE AND MP.MATRICULA = SF.MATRICULA AND ((MP.TIPOMOVIMENTACAO IN (8, 9, 10, 11)) OR MP.TIPOMOVIMENTACAO = 7 AND (R.MOTIVO IN (70, 71, 72, 73, 74, 75, 76, 77, 78, 79))))) THEN 'APOSENTADO'
          WHEN SF.SITUACAO = 3 THEN 'DEMITIDO'
          ELSE 'ATIVO'
       END AS SITUACAO
      FROM RHHISTORICOFUNCIONARIO SF
      WHERE SF.ANOCOMPETENCIA = :exercicio
        AND SF.ENTIDADE = F.ENTIDADE
        AND SF.MATRICULA = F.MATRICULA
        AND SF.TIPOFOLHA = FNC_GETTIPOFOLHAPRINCIPAL(F.ENTIDADE)
        AND SF.MESCOMPETENCIA = (( SELECT MAX(HFX.MESCOMPETENCIA) AS MAX
                                     FROM RHHISTORICOFUNCIONARIO HFX
                                    WHERE HFX.ENTIDADE = SF.ENTIDADE
                                      AND HFX.MATRICULA = SF.MATRICULA
                                      AND HFX.ANOCOMPETENCIA = SF.ANOCOMPETENCIA
                                      AND HFX.TIPOFOLHA = SF.TIPOFOLHA))) SITUACAO,
  CASE WHEN F.SITUACAO = 3 AND F.DATASITUACAO <= :dataAtual THEN F.DATASITUACAO ELSE NULL END AS DATADEMISSAO,
  C.DESCRICAO AS DESCRICAOCARGO,  
  CL.DESCRICAO AS DESCRICAOCLASSE,  
  RDC.DESCRICAO AS DESCRICAONATUREZA,
  RL.DESCRICAO AS DESCRICAOLOTACAO
  FROM RHFUNCIONARIO F   
   LEFT OUTER JOIN PESSOA  P   
     ON F.PESSOA = P.PESSOA  
   LEFT OUTER JOIN RHCARGO C   
     ON F.ENTIDADE = C.ENTIDADE     
    AND F.CARGO = C.CARGO    
   LEFT OUTER JOIN RHCLASSE CL   
     ON F.ENTIDADE = CL.ENTIDADE     
    AND F.CLASSE = CL.CLASSE    
   LEFT OUTER JOIN RHDEFINICAOCLASSE RDC       
     ON CL.DEFINICAO = RDC.DEFINICAO     
   LEFT OUTER JOIN RHLOTACAO RL       
     ON F.ENTIDADE = RL.ENTIDADE      
    AND F.MODELOLOTACAO = RL.MODELOLOTACAO      
    AND F.NIVELLOTACAO = RL.NIVELLOTACAO      
    AND F.LOTACAO = RL.LOTACAO  
  WHERE F.ENTIDADE = :entidade
    AND ((F.SITUACAO <> 3) OR (F.SITUACAO = 3 AND F.DATASITUACAO >= INICIOCOMPETENCIA(:exercicio,01)))
    AND EXISTS ( 
            SELECT MP.MATRICULA
              FROM RHMOVIMENTACAOPESSOAL MP
              JOIN RHMOVIMENTACAOLEGAL ML ON MP.ENTIDADE = ML.ENTIDADE
               AND MP.MATRICULA = ML.MATRICULA
               AND MP.MOVIMENTACAO = ML.MOVIMENTACAO
             WHERE MP.MATRICULA = F.MATRICULA
               AND MP.ENTIDADE = F.ENTIDADE
               AND MP.TIPOMOVIMENTACAO IN (39, 67)
               AND EXTRACT(YEAR FROM ML.DATABENEFICIO)  <= :exercicio
        )
    AND EXTRACT(YEAR FROM F.DATAADMISSAO) <= :exercicio
