/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service.impl;

import br.com.elotech.core.mail.MailService;
import br.com.elotech.core.mail.impl.MailParams;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.MensagemDTO;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import br.com.elotech.portaltransparencia.contabportal.service.MensagemService;
import br.com.elotech.portaltransparencia.contabportal.service.impl.ProcessoMailServiceImpl;
import java.util.Locale;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring5.SpringTemplateEngine;

@Service
public class MensagemServiceImpl
implements MensagemService {
    private final Logger log = LoggerFactory.getLogger(ProcessoMailServiceImpl.class);
    private final Locale locale = Locale.getDefault();
    private final MailService mailService;
    private final SpringTemplateEngine templateEngine;
    private final EntidadeContabilidadeService entidadeService;

    public MensagemServiceImpl(MailService mailService, SpringTemplateEngine templateEngine, EntidadeContabilidadeService entidadeService) {
        this.mailService = mailService;
        this.templateEngine = templateEngine;
        this.entidadeService = entidadeService;
    }

    public Future<Boolean> enviarMensagem(MensagemDTO mensagem, String destinatario, Long entidade) {
        this.log.debug("Enviando email para '{}'", (Object)mensagem.getEmail());
        MailParams mailParams = MailParams.builder().to(destinatario).subject("[Portal Transpar\u00eancia] " + mensagem.getAssunto()).content(this.buildContent(mensagem, entidade)).multipart(false).html(true).build();
        return this.mailService.sendEmail(mailParams);
    }

    private String buildContent(MensagemDTO mensagem, Long idEntidade) {
        Context context = new Context(this.locale);
        context.setVariable("email", (Object)mensagem.getEmail());
        context.setVariable("nome", (Object)mensagem.getNome());
        context.setVariable("mensagem", (Object)mensagem.getMensagem());
        context.setVariable("assunto", (Object)mensagem.getAssunto());
        Entidade entidade = this.entidadeService.findOne(idEntidade);
        context.setVariable("entidadeNome", (Object)entidade.getNome());
        return this.templateEngine.process("simplesEmail", (IContext)context);
    }
}

