/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain.dto;

import br.com.elotech.contabilidade.client.dto.EmLiquidacaoDTO;
import br.com.elotech.contabilidade.client.dto.ExercicioDTO;
import br.com.elotech.contabilidade.client.dto.PessoaDTO;
import br.com.elotech.contabilidade.client.dto.ResponsavelDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoEmLiquidacaoDTO;
import br.com.elotech.portaltransparencia.utils.MaskFormatterUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Optional;
import lombok.Generated;

public class EmpenhoEmLiquidacaoDTO {
    private Long id;
    private Long entidade;
    private Long exercicio;
    private Long noEmLiquidacao;
    private Long noDocOrigem;
    private Long anoDocOrigem;
    private String historico;
    private Long fornecedor;
    private String nomeFornecedor;
    private String cnpj;
    private LocalDate data;
    private LocalDate dataVencimento;
    private BigDecimal valor;
    private BigDecimal valorEmpenho;
    private BigDecimal valorEstornado;
    private BigDecimal valorLiquidado;

    public EmpenhoEmLiquidacaoDTO(EmLiquidacaoDTO emLiquidacao) {
        ExercicioDTO exercicioEmLiq = emLiquidacao.getExercicio();
        ResponsavelDTO responsavel = emLiquidacao.getResponsavel();
        PessoaDTO pessoa = responsavel.getPessoa();
        this.id = emLiquidacao.getId();
        this.entidade = exercicioEmLiq.getEntidade().getId();
        this.exercicio = exercicioEmLiq.getExercicio();
        this.noEmLiquidacao = emLiquidacao.getNumeroEmLiquidacao();
        this.historico = emLiquidacao.getComplementoHistorico();
        this.fornecedor = pessoa.getId();
        this.nomeFornecedor = pessoa.getNome();
        this.cnpj = MaskFormatterUtils.getMaskFormatado((String)Optional.ofNullable(pessoa.getCnpjCpf()).orElse(""), (String)"##.###.###/####-##");
        this.data = emLiquidacao.getDataEmLiquidacao();
        this.dataVencimento = emLiquidacao.getDataVencimento();
        this.valor = emLiquidacao.getMovimentoAtePeriodo().getEmLiquidacao();
        this.valorEmpenho = emLiquidacao.getEmpenho().getValor();
        this.valorEstornado = emLiquidacao.getMovimentoAtePeriodo().getEmLiquidacaoAnulado();
        this.valorLiquidado = emLiquidacao.getMovimentoAtePeriodo().getSaldoLiquidado();
    }

    @Generated
    public static EmpenhoEmLiquidacaoDTOBuilder builder() {
        return new EmpenhoEmLiquidacaoDTOBuilder();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getNoEmLiquidacao() {
        return this.noEmLiquidacao;
    }

    @Generated
    public Long getNoDocOrigem() {
        return this.noDocOrigem;
    }

    @Generated
    public Long getAnoDocOrigem() {
        return this.anoDocOrigem;
    }

    @Generated
    public String getHistorico() {
        return this.historico;
    }

    @Generated
    public Long getFornecedor() {
        return this.fornecedor;
    }

    @Generated
    public String getNomeFornecedor() {
        return this.nomeFornecedor;
    }

    @Generated
    public String getCnpj() {
        return this.cnpj;
    }

    @Generated
    public LocalDate getData() {
        return this.data;
    }

    @Generated
    public LocalDate getDataVencimento() {
        return this.dataVencimento;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public BigDecimal getValorEmpenho() {
        return this.valorEmpenho;
    }

    @Generated
    public BigDecimal getValorEstornado() {
        return this.valorEstornado;
    }

    @Generated
    public BigDecimal getValorLiquidado() {
        return this.valorLiquidado;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setNoEmLiquidacao(Long noEmLiquidacao) {
        this.noEmLiquidacao = noEmLiquidacao;
    }

    @Generated
    public void setNoDocOrigem(Long noDocOrigem) {
        this.noDocOrigem = noDocOrigem;
    }

    @Generated
    public void setAnoDocOrigem(Long anoDocOrigem) {
        this.anoDocOrigem = anoDocOrigem;
    }

    @Generated
    public void setHistorico(String historico) {
        this.historico = historico;
    }

    @Generated
    public void setFornecedor(Long fornecedor) {
        this.fornecedor = fornecedor;
    }

    @Generated
    public void setNomeFornecedor(String nomeFornecedor) {
        this.nomeFornecedor = nomeFornecedor;
    }

    @Generated
    public void setCnpj(String cnpj) {
        this.cnpj = cnpj;
    }

    @Generated
    public void setData(LocalDate data) {
        this.data = data;
    }

    @Generated
    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setValorEmpenho(BigDecimal valorEmpenho) {
        this.valorEmpenho = valorEmpenho;
    }

    @Generated
    public void setValorEstornado(BigDecimal valorEstornado) {
        this.valorEstornado = valorEstornado;
    }

    @Generated
    public void setValorLiquidado(BigDecimal valorLiquidado) {
        this.valorLiquidado = valorLiquidado;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmpenhoEmLiquidacaoDTO)) {
            return false;
        }
        EmpenhoEmLiquidacaoDTO other = (EmpenhoEmLiquidacaoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$noEmLiquidacao = this.getNoEmLiquidacao();
        Long other$noEmLiquidacao = other.getNoEmLiquidacao();
        if (this$noEmLiquidacao == null ? other$noEmLiquidacao != null : !((Object)this$noEmLiquidacao).equals(other$noEmLiquidacao)) {
            return false;
        }
        Long this$noDocOrigem = this.getNoDocOrigem();
        Long other$noDocOrigem = other.getNoDocOrigem();
        if (this$noDocOrigem == null ? other$noDocOrigem != null : !((Object)this$noDocOrigem).equals(other$noDocOrigem)) {
            return false;
        }
        Long this$anoDocOrigem = this.getAnoDocOrigem();
        Long other$anoDocOrigem = other.getAnoDocOrigem();
        if (this$anoDocOrigem == null ? other$anoDocOrigem != null : !((Object)this$anoDocOrigem).equals(other$anoDocOrigem)) {
            return false;
        }
        String this$historico = this.getHistorico();
        String other$historico = other.getHistorico();
        if (this$historico == null ? other$historico != null : !this$historico.equals(other$historico)) {
            return false;
        }
        Long this$fornecedor = this.getFornecedor();
        Long other$fornecedor = other.getFornecedor();
        if (this$fornecedor == null ? other$fornecedor != null : !((Object)this$fornecedor).equals(other$fornecedor)) {
            return false;
        }
        String this$nomeFornecedor = this.getNomeFornecedor();
        String other$nomeFornecedor = other.getNomeFornecedor();
        if (this$nomeFornecedor == null ? other$nomeFornecedor != null : !this$nomeFornecedor.equals(other$nomeFornecedor)) {
            return false;
        }
        String this$cnpj = this.getCnpj();
        String other$cnpj = other.getCnpj();
        if (this$cnpj == null ? other$cnpj != null : !this$cnpj.equals(other$cnpj)) {
            return false;
        }
        LocalDate this$data = this.getData();
        LocalDate other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        LocalDate this$dataVencimento = this.getDataVencimento();
        LocalDate other$dataVencimento = other.getDataVencimento();
        if (this$dataVencimento == null ? other$dataVencimento != null : !((Object)this$dataVencimento).equals(other$dataVencimento)) {
            return false;
        }
        BigDecimal this$valor = this.getValor();
        BigDecimal other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor)) {
            return false;
        }
        BigDecimal this$valorEmpenho = this.getValorEmpenho();
        BigDecimal other$valorEmpenho = other.getValorEmpenho();
        if (this$valorEmpenho == null ? other$valorEmpenho != null : !((Object)this$valorEmpenho).equals(other$valorEmpenho)) {
            return false;
        }
        BigDecimal this$valorEstornado = this.getValorEstornado();
        BigDecimal other$valorEstornado = other.getValorEstornado();
        if (this$valorEstornado == null ? other$valorEstornado != null : !((Object)this$valorEstornado).equals(other$valorEstornado)) {
            return false;
        }
        BigDecimal this$valorLiquidado = this.getValorLiquidado();
        BigDecimal other$valorLiquidado = other.getValorLiquidado();
        return !(this$valorLiquidado == null ? other$valorLiquidado != null : !((Object)this$valorLiquidado).equals(other$valorLiquidado));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EmpenhoEmLiquidacaoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $noEmLiquidacao = this.getNoEmLiquidacao();
        result = result * 59 + ($noEmLiquidacao == null ? 43 : ((Object)$noEmLiquidacao).hashCode());
        Long $noDocOrigem = this.getNoDocOrigem();
        result = result * 59 + ($noDocOrigem == null ? 43 : ((Object)$noDocOrigem).hashCode());
        Long $anoDocOrigem = this.getAnoDocOrigem();
        result = result * 59 + ($anoDocOrigem == null ? 43 : ((Object)$anoDocOrigem).hashCode());
        String $historico = this.getHistorico();
        result = result * 59 + ($historico == null ? 43 : $historico.hashCode());
        Long $fornecedor = this.getFornecedor();
        result = result * 59 + ($fornecedor == null ? 43 : ((Object)$fornecedor).hashCode());
        String $nomeFornecedor = this.getNomeFornecedor();
        result = result * 59 + ($nomeFornecedor == null ? 43 : $nomeFornecedor.hashCode());
        String $cnpj = this.getCnpj();
        result = result * 59 + ($cnpj == null ? 43 : $cnpj.hashCode());
        LocalDate $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        LocalDate $dataVencimento = this.getDataVencimento();
        result = result * 59 + ($dataVencimento == null ? 43 : ((Object)$dataVencimento).hashCode());
        BigDecimal $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        BigDecimal $valorEmpenho = this.getValorEmpenho();
        result = result * 59 + ($valorEmpenho == null ? 43 : ((Object)$valorEmpenho).hashCode());
        BigDecimal $valorEstornado = this.getValorEstornado();
        result = result * 59 + ($valorEstornado == null ? 43 : ((Object)$valorEstornado).hashCode());
        BigDecimal $valorLiquidado = this.getValorLiquidado();
        result = result * 59 + ($valorLiquidado == null ? 43 : ((Object)$valorLiquidado).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EmpenhoEmLiquidacaoDTO(id=" + this.getId() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", noEmLiquidacao=" + this.getNoEmLiquidacao() + ", noDocOrigem=" + this.getNoDocOrigem() + ", anoDocOrigem=" + this.getAnoDocOrigem() + ", historico=" + this.getHistorico() + ", fornecedor=" + this.getFornecedor() + ", nomeFornecedor=" + this.getNomeFornecedor() + ", cnpj=" + this.getCnpj() + ", data=" + this.getData() + ", dataVencimento=" + this.getDataVencimento() + ", valor=" + this.getValor() + ", valorEmpenho=" + this.getValorEmpenho() + ", valorEstornado=" + this.getValorEstornado() + ", valorLiquidado=" + this.getValorLiquidado() + ")";
    }

    @Generated
    public EmpenhoEmLiquidacaoDTO() {
    }

    @Generated
    public EmpenhoEmLiquidacaoDTO(Long id, Long entidade, Long exercicio, Long noEmLiquidacao, Long noDocOrigem, Long anoDocOrigem, String historico, Long fornecedor, String nomeFornecedor, String cnpj, LocalDate data, LocalDate dataVencimento, BigDecimal valor, BigDecimal valorEmpenho, BigDecimal valorEstornado, BigDecimal valorLiquidado) {
        this.id = id;
        this.entidade = entidade;
        this.exercicio = exercicio;
        this.noEmLiquidacao = noEmLiquidacao;
        this.noDocOrigem = noDocOrigem;
        this.anoDocOrigem = anoDocOrigem;
        this.historico = historico;
        this.fornecedor = fornecedor;
        this.nomeFornecedor = nomeFornecedor;
        this.cnpj = cnpj;
        this.data = data;
        this.dataVencimento = dataVencimento;
        this.valor = valor;
        this.valorEmpenho = valorEmpenho;
        this.valorEstornado = valorEstornado;
        this.valorLiquidado = valorLiquidado;
    }
}

