/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.service.impl;

import br.com.elotech.core.config.DBConfigProperties;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.DividaAtivaContribuinteDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.DividaAtivaDTO;
import br.com.elotech.portaltransparencia.aiseportal.repository.DividaAtivaRepository;
import br.com.elotech.portaltransparencia.aiseportal.repository.impl.DividaAtivaRepositoryImpl;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.FindDividaAtivaParams;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.smtportal.repository.DividaAtivaSmtRepository;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class DividaAtivaSmtServiceImpl {
    private final DBConfigProperties dbConfigProperties;
    private final DividaAtivaSmtRepository dividaAtivaRepositorySmt;
    private DividaAtivaRepository dividaAtivaRepositoryAise;

    public DividaAtivaSmtServiceImpl(@Qualifier(value="wrapperSmt") DatasourceWrapper datasourceWrapperSmt, DividaAtivaSmtRepository dividaAtivaRepositorySmt, DBConfigProperties dbConfigProperties) {
        this.dividaAtivaRepositorySmt = dividaAtivaRepositorySmt;
        this.dbConfigProperties = dbConfigProperties;
        this.dividaAtivaRepositoryAise = new DividaAtivaRepositoryImpl(datasourceWrapperSmt);
    }

    public Page<DividaAtivaDTO> findDividasAtivas(FindDividaAtivaParams params, Pageable pageable) {
        if (this.isFonteDadosSmtConectadoAise().booleanValue()) {
            return this.dividaAtivaRepositoryAise.findDividasAtivas(params, pageable);
        }
        return this.dividaAtivaRepositorySmt.findDividasAtivas(params, pageable);
    }

    public List<DividaAtivaContribuinteDTO> findDividasAtivasContribuinte(FindDividaAtivaParams params) {
        if (this.isFonteDadosSmtConectadoAise().booleanValue()) {
            return this.dividaAtivaRepositoryAise.findDividasAtivasContribuinte(params);
        }
        return this.dividaAtivaRepositorySmt.findDividasAtivasContribuinte(params);
    }

    protected Boolean isFonteDadosSmtConectadoAise() {
        if (Objects.isNull(this.dbConfigProperties.getSmt()) || StringUtils.isBlank((CharSequence)this.dbConfigProperties.getSmt().getDb()) || StringUtils.isBlank((CharSequence)this.dbConfigProperties.getSmt().getUser())) {
            throw new IllegalArgumentException("O sistema Tribut\u00e1rio n\u00e3o est\u00e1 configurado corretamente.");
        }
        return !StringUtils.containsIgnoreCase((CharSequence)this.dbConfigProperties.getSmt().getPlatform(), (CharSequence)"SQLServer") && !StringUtils.containsIgnoreCase((CharSequence)this.dbConfigProperties.getSmt().getPlatform(), (CharSequence)"MSSQL");
    }

    protected void setDividaAtivaRepositoryAise(DividaAtivaRepository dividaAtivaRepository) {
        this.dividaAtivaRepositoryAise = dividaAtivaRepository;
    }
}

