SELECT DISTINCT VC.ENTIDADE,
       VC.MATRICULA,
       VC.MESCOMPETENCIA,
       VC.ANOCOMPETENCIA,
       VC.TIPOFOLHA,
       VC.DESCRICAOTIPOFOLHA,
       fnc_getsalariofuncportal(VC.ENTIDADE,VC.MATRICULA,VC.MESCOMPETENCIA,
                                VC.ANOCOMPETENCIA, VC.TIPOFOLHA, VC.COMPETENCIALANCAMENTO) SALARIOBASE,
  (SELECT SUM(FFP.VALOR) FROM RHFICHAFINANCEIRA FFP
     LEFT OUTER JOIN RHEVENTO EVP
       ON FFP.ENTIDADE = EVP.ENTIDADE
      AND FFP.EVENTO = EVP.EVENTO
    WHERE FFP.ENTIDADE = VC.ENTIDADE
      AND FFP.MATRICULA = VC.MATRICULA
      AND FFP.ANOCOMPETENCIA = VC.ANOCOMPETENCIA
      AND FFP.MESCOMPETENCIA = VC.MESCOMPETENCIA
      AND FFP.TIPOFOLHA = VC.TIPOFOLHA
      AND FFP.SITUACAO = 1
      AND EVP.TIPO = 'P'
      AND EVP.DEFINICAO <> 1) AS OUTROSPROVENTOS,
  (SELECT SUM(FFP.VALOR) FROM RHFICHAFINANCEIRA FFP
     LEFT OUTER JOIN RHEVENTO EVP
       ON FFP.ENTIDADE = EVP.ENTIDADE
      AND FFP.EVENTO = EVP.EVENTO
    WHERE FFP.ENTIDADE = VC.ENTIDADE
      AND FFP.MATRICULA = VC.MATRICULA
      AND FFP.ANOCOMPETENCIA = VC.ANOCOMPETENCIA
      AND FFP.MESCOMPETENCIA = VC.MESCOMPETENCIA
      AND FFP.TIPOFOLHA = VC.TIPOFOLHA
      AND FFP.SITUACAO = 1
      AND EVP.TIPO = 'P') AS VENCIMENTOS,
  (SELECT SUM(FFP.VALOR) FROM RHFICHAFINANCEIRA FFP
     LEFT OUTER JOIN RHEVENTO EVP
       ON FFP.ENTIDADE = EVP.ENTIDADE
      AND FFP.EVENTO = EVP.EVENTO
    WHERE FFP.ENTIDADE = VC.ENTIDADE
      AND FFP.MATRICULA = VC.MATRICULA
      AND FFP.ANOCOMPETENCIA = VC.ANOCOMPETENCIA
      AND FFP.MESCOMPETENCIA = VC.MESCOMPETENCIA
      AND FFP.TIPOFOLHA = VC.TIPOFOLHA
      AND FFP.SITUACAO = 1
      AND EVP.TIPO = 'D' 
      $[FILTRO]) AS DESCONTOS,
  (SELECT SUM(FFP.VALOR) FROM RHFICHAFINANCEIRA FFP
     LEFT OUTER JOIN RHEVENTO EVP
       ON FFP.ENTIDADE = EVP.ENTIDADE
      AND FFP.EVENTO = EVP.EVENTO
    WHERE FFP.ENTIDADE = VC.ENTIDADE
      AND FFP.MATRICULA = VC.MATRICULA
      AND FFP.ANOCOMPETENCIA = VC.ANOCOMPETENCIA
      AND FFP.MESCOMPETENCIA = VC.MESCOMPETENCIA
      AND FFP.TIPOFOLHA = VC.TIPOFOLHA
      AND FFP.SITUACAO = 1
      AND EVP.TIPO = 'D' 
      AND EVP.DEFINICAO = 83) AS REDUTORCONSTITUCIONAL
 FROM (
 SELECT DISTINCT
        F.ENTIDADE,
        F.MATRICULA,
        FF.TIPOFOLHA,
        TF.DESCRICAO as DESCRICAOTIPOFOLHA,
        FF.FECHAMENTOCONTABIL,
        FF.COMPETENCIALANCAMENTO,
        FF.ANOCOMPETENCIA,
        FF.MESCOMPETENCIA
   FROM RHFUNCIONARIO F
   JOIN RHFICHAFINANCEIRA FF
     ON FF.ENTIDADE = F.ENTIDADE
    AND FF.MATRICULA = F.MATRICULA
    AND FF.ANOCOMPETENCIA = :exercicio
    AND FF.SITUACAO = 1
   JOIN RHTIPOFOLHA TF
     ON FF.ENTIDADE = TF.ENTIDADE
    AND FF.TIPOFOLHA = TF.TIPOFOLHA
   LEFT OUTER JOIN VW_SITUACAOFUNCIONARIO SF
     ON F.ENTIDADE = SF.ENTIDADE
    AND F.MATRICULA = SF.MATRICULA
   LEFT OUTER JOIN RHFECHAMENTOCONTABIL FC
     ON FF.ENTIDADE = FC.ENTIDADE
    AND FF.ANOCOMPETENCIA = FC.ANOCOMPETENCIA
    AND FF.MESCOMPETENCIA = FC.MESCOMPETENCIA
    AND FF.FECHAMENTOCONTABIL = FC.FECHAMENTOCONTABIL
  WHERE F.ENTIDADE = :entidade
    AND F.MATRICULA = :matricula
    AND TF.DIVULGAPORTAL = 'S' 
    AND FF.LIBERADOPORTAL = 'S') VC
  LEFT OUTER JOIN RHMOVIMENTACAOPESSOAL NOM
    ON VC.ENTIDADE = NOM.ENTIDADE
   AND VC.MATRICULA = NOM.MATRICULA
   AND NOM.TIPOMOVIMENTACAO = 1
  LEFT OUTER JOIN CGATO CGATO
    ON NOM.ENTIDADE = CGATO.ENTIDADE
   AND NOM.IDATO = CGATO.IDATO
  LEFT OUTER JOIN RHHISTORICOFUNCIONARIO HF
    ON HF.ENTIDADE = VC.ENTIDADE
   AND HF.MATRICULA = VC.MATRICULA
   AND HF.ANOCOMPETENCIA = VC.ANOCOMPETENCIA
   AND HF.MESCOMPETENCIA = VC.MESCOMPETENCIA
   AND ((HF.TIPOFOLHA = VC.TIPOFOLHA AND VC.TIPOFOLHA IS NOT NULL) OR (VC.TIPOFOLHA IS NULL AND HF.TIPOFOLHA = 1))
   AND (HF.FECHAMENTOCONTABIL = VC.FECHAMENTOCONTABIL OR VC.FECHAMENTOCONTABIL IS NULL)
  LEFT OUTER JOIN RHTIPOFOLHA TF
    ON HF.ENTIDADE = TF.ENTIDADE
   AND HF.TIPOFOLHA = TF.TIPOFOLHA
 ORDER BY VC.ANOCOMPETENCIA, VC.MESCOMPETENCIA
