/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.service.PortalParametroService;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ReceitaDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.ReceitaXDespesaRepository;
import br.com.elotech.portaltransparencia.contabportal.repository.impl.EntidadeContabilidadeRepositoryImpl;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindReceitaParams;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ReceitaXDespesaRepositoryImpl
implements ReceitaXDespesaRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReceitaXDespesaRepositoryImpl.class);
    private static final String RECEITAS_EMPENHADOS_MES = "db/sql/contab/receitas_empenhados_mes_covid.sql";
    private static final String RECEITAS_EMPENHADOS_MES_ENTIDADES_DIFERENTES = "db/sql/contab/receitas_empenhados_mes_covid_entidades_diferentes.sql";
    private static final String EMPENHADO_ANUAL = "db/sql/contab/empenhado_anual_covid.sql";
    private static final String REPLACE_ENTIDADE_EMPENHO_ANUAL = " AND E.ENTIDADE = :entidade";
    private final DatasourceWrapper datasourceWrapper;
    private final EntidadeContabilidadeRepositoryImpl entidadeContabilidade;
    private final PortalParametroService portalParametroService;

    @Autowired
    public ReceitaXDespesaRepositoryImpl(@Qualifier(value="wrapperContabilidade") DatasourceWrapper datasourceWrapper, EntidadeContabilidadeRepositoryImpl entidadeContabilidade, PortalParametroService portalParametroService) {
        this.datasourceWrapper = datasourceWrapper;
        this.entidadeContabilidade = entidadeContabilidade;
        this.portalParametroService = portalParametroService;
    }

    public List<ReceitaDTO> findReceitasEmpenhadosPorMes(FindReceitaParams params) {
        String sql = FileUtils.readResourceAsString((String)RECEITAS_EMPENHADOS_MES);
        if (SimNao.toBoolean((String)this.portalParametroService.getPortalParametroValor(Parametros.NAO_DEPENDE_ENTIDADE, params.getExercicio(), Parametros.PARAM_RECEITAS_ENTIDADES_DIFERENTES)).booleanValue()) {
            sql = FileUtils.readResourceAsString((String)RECEITAS_EMPENHADOS_MES_ENTIDADES_DIFERENTES);
        }
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(this.entidadeContabilidade.getTamanhoReceita(params.getEntidade(), params.getExercicio()).intValue()), (RowMapper)new ElotechBeanPropertyRowMapper(ReceitaDTO.class));
    }

    private void consoleLogger(FindReceitaParams params, String sql) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(sql);
            LOGGER.debug(params.toString());
        }
    }

    public BigDecimal getValorEmpenhadoAnual(FindReceitaParams params) {
        String sql = FileUtils.readResourceAsString((String)EMPENHADO_ANUAL);
        if (!SimNao.toBoolean((String)this.portalParametroService.getPortalParametroValor(Parametros.NAO_DEPENDE_ENTIDADE, params.getExercicio(), Parametros.PARAM_DESPESAS_ENTIDADES_DIFERENTES)).booleanValue()) {
            sql = sql.concat(REPLACE_ENTIDADE_EMPENHO_ANUAL);
        }
        this.consoleLogger(params, sql);
        return (BigDecimal)this.datasourceWrapper.getJdbcTemplate().queryForObject(sql, (SqlParameterSource)params.toJdbcParameter(this.entidadeContabilidade.getTamanhoReceita(params.getEntidade(), params.getExercicio()).intValue()), BigDecimal.class);
    }
}

