/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.saude.service;

import br.com.elotech.portaltransparencia.saude.domain.dto.DocumentoDTO;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class DocumentosService {
    private final RestTemplate restTemplate;
    private String urlSaude;
    private Boolean sistemaSaude;

    public DocumentosService(@Value(value="${elotech.sistemaSaude.url:}") String urlSaude, @Value(value="${elotech.sistemaSaude.enabled:false}") Boolean sistemaSaude, RestTemplateBuilder restTemplateBuilder) {
        this.restTemplate = restTemplateBuilder.build();
        this.urlSaude = urlSaude;
        this.sistemaSaude = sistemaSaude;
    }

    public List<DocumentoDTO> findDocumentos() {
        if (Boolean.FALSE.equals(this.sistemaSaude) || this.urlSaude.isEmpty()) {
            return new ArrayList<DocumentoDTO>();
        }
        URI uri = URI.create(String.format("%s/WebSocialSaude/rest/saude/documentos/", this.urlSaude));
        RequestEntity requestEntity = RequestEntity.get((URI)uri).build();
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(requestEntity, DocumentoDTO[].class);
            return Arrays.asList((Object[])Objects.requireNonNull(responseEntity.getBody()));
        }
        catch (HttpClientErrorException e) {
            return new ArrayList<DocumentoDTO>();
        }
    }

    public DocumentoDTO getArquivo(Long id) {
        URI uri = URI.create(String.format("%s/WebSocialSaude/rest/saude/documentos/%d", this.urlSaude, id));
        RequestEntity requestEntity = RequestEntity.get((URI)uri).build();
        ResponseEntity responseEntity = this.restTemplate.exchange(requestEntity, DocumentoDTO[].class);
        List<Object> documentos = Arrays.asList((Object[])Objects.requireNonNull(responseEntity.getBody()));
        return (DocumentoDTO)documentos.get(0);
    }

    public void setUrlSaude(String urlSaude) {
        this.urlSaude = urlSaude;
    }

    public void setSistemaSaude(Boolean sistemaSaude) {
        this.sistemaSaude = sistemaSaude;
    }
}

