 SELECT B.COTACAO, 
        B.PESSOA, 
        P.NOME, 
        P.CNPJ_CPF AS CNPJCPF, 
        B.DATA, C.IDARQUIVO, 
        CASE WHEN C.NOMEARQUIVO IS NULL THEN ELOARQ.NOME ELSE C.NOMEARQUIVO END AS NOMEARQUIVO, 
        C.DATA AS DATAPUBLICACAO,
        LENGTH(AC.ARQUIVO) AS TAMANHOARQUIVO
   FROM CLLICITACAO A  
   LEFT JOIN CLCOTACAO B 
     ON A.ENTIDADE = B.ENTIDADE  
    AND A.EXERCICIO = B.EXERCICIO  
    AND A.COTACAO = B.COTACAO  
   LEFT JOIN PESSOA P 
     ON B.PESSOA = P.PESSOA  
   LEFT JOIN ARQUIVO C  
     ON C.ID = B.IDARQUIVO  
   LEFT JOIN schema_eloarquivo.ARQUIVO ELOARQ
     ON ELOARQ.ID = C.IDARQUIVO
   LEFT JOIN schema_eloarquivo.ARQUIVO_CONTENT AC  
     ON C.IDARQUIVO = AC.ID  
  WHERE A.ENTIDADE = :entidade 
    AND A.EXERCICIO = :exercicio 
    AND A.TIPOLICITACAO = :tipoLicitacao 
    AND A.LICITACAO = :licitacao 
  ORDER BY P.NOME