/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.GastoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ReceitaDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.DashboardRepository;
import br.com.elotech.portaltransparencia.contabportal.repository.impl.EntidadeContabilidadeRepositoryImpl;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindReceitaParams;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class DashboardRepositoryImpl
implements DashboardRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(DashboardRepositoryImpl.class);
    private static final String RECEITAS_EMPENHADOS_MES = "db/sql/contab/receitas_empenhados_mes.sql";
    private static final String RECEITA_VALOR_ATUALIZADO = "db/sql/contab/receita_valor_atualizado.sql";
    private static final String DESPESA_VALOR_ATUALIZADO = "db/sql/contab/despesa_valor_atualizado.sql";
    private static final String RECEITAS_DASHBOARD = "db/sql/contab/receitas_dashboard.sql";
    private static final String RECEITASPREVISAO_DASHBOARD = "db/sql/contab/receitasprevisao_dashboard.sql";
    private static final String GASTOS_PESSOAL = "db/sql/contab/gastosPessoal.sql";
    private static final String GASTOS_EDUCACAO = "db/sql/contab/gastosEducacao.sql";
    private static final String GASTOS_SAUDE = "db/sql/contab/gastosSaude.sql";
    private final DatasourceWrapper datasourceWrapper;
    private final EntidadeContabilidadeRepositoryImpl entidadeContabilidade;

    @Autowired
    public DashboardRepositoryImpl(@Qualifier(value="wrapperContabilidade") DatasourceWrapper datasourceWrapper, EntidadeContabilidadeRepositoryImpl entidadeContabilidade) {
        this.datasourceWrapper = datasourceWrapper;
        this.entidadeContabilidade = entidadeContabilidade;
    }

    public List<ReceitaDTO> findReceitasEmpenhadosPorMes(FindReceitaParams params) {
        String sql = FileUtils.readResourceAsString((String)RECEITAS_EMPENHADOS_MES);
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(this.entidadeContabilidade.getTamanhoReceita(params.getEntidade(), params.getExercicio()).intValue()), (RowMapper)new ElotechBeanPropertyRowMapper(ReceitaDTO.class));
    }

    private void consoleLogger(FindReceitaParams params, String sql) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(sql);
            LOGGER.debug(params.toString());
        }
    }

    public BigDecimal getReceitaValorAtualizado(FindReceitaParams params) {
        String sql = FileUtils.readResourceAsString((String)RECEITA_VALOR_ATUALIZADO);
        this.consoleLogger(params, sql);
        return (BigDecimal)this.datasourceWrapper.getJdbcTemplate().queryForObject(sql, (SqlParameterSource)params.toJdbcParameter(this.entidadeContabilidade.getTamanhoReceita(params.getEntidade(), params.getExercicio()).intValue()), BigDecimal.class);
    }

    public BigDecimal getDespesaValorAtualizado(FindReceitaParams params) {
        String sql = FileUtils.readResourceAsString((String)DESPESA_VALOR_ATUALIZADO);
        this.consoleLogger(params, sql);
        return (BigDecimal)this.datasourceWrapper.getJdbcTemplate().queryForObject(sql, (SqlParameterSource)params.toJdbcParameter(this.entidadeContabilidade.getTamanhoReceita(params.getEntidade(), params.getExercicio()).intValue()), BigDecimal.class);
    }

    public List<GastoDTO> findGastosPessoal(FindReceitaParams params) {
        String sql = FileUtils.readResourceAsString((String)GASTOS_PESSOAL);
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(this.entidadeContabilidade.getTamanhoReceita(params.getEntidade(), params.getExercicio()).intValue()), (RowMapper)new ElotechBeanPropertyRowMapper(GastoDTO.class));
    }

    public List<GastoDTO> findGastosEducacao(FindReceitaParams params) {
        String sql = FileUtils.readResourceAsString((String)GASTOS_EDUCACAO);
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(this.entidadeContabilidade.getTamanhoReceita(params.getEntidade(), params.getExercicio()).intValue()), (RowMapper)new ElotechBeanPropertyRowMapper(GastoDTO.class));
    }

    public List<GastoDTO> findGastosSaude(FindReceitaParams params) {
        String sql = FileUtils.readResourceAsString((String)GASTOS_SAUDE);
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(this.entidadeContabilidade.getTamanhoReceita(params.getEntidade(), params.getExercicio()).intValue()), (RowMapper)new ElotechBeanPropertyRowMapper(GastoDTO.class));
    }

    public List<ReceitaDTO> findReceitasDashBoardPorMes(FindReceitaParams params) {
        String sqlreceitasprevisao = FileUtils.readResourceAsString((String)RECEITASPREVISAO_DASHBOARD);
        String sqlreceitas = FileUtils.readResourceAsString((String)RECEITAS_DASHBOARD);
        this.consoleLogger(params, sqlreceitasprevisao);
        List receitas = this.datasourceWrapper.getJdbcTemplate().query(sqlreceitasprevisao, (SqlParameterSource)params.toJdbcParameter(this.entidadeContabilidade.getTamanhoReceita(params.getEntidade(), params.getExercicio()).intValue()), (RowMapper)new ElotechBeanPropertyRowMapper(ReceitaDTO.class));
        if (receitas.isEmpty()) {
            return this.datasourceWrapper.getJdbcTemplate().query(sqlreceitas, (SqlParameterSource)params.toJdbcParameter(this.entidadeContabilidade.getTamanhoReceita(params.getEntidade(), params.getExercicio()).intValue()), (RowMapper)new ElotechBeanPropertyRowMapper(ReceitaDTO.class));
        }
        return receitas;
    }
}

