/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.service.impl;

import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.repository.PortalParametroRepository;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.AiseParams;
import br.com.elotech.portaltransparencia.aiseportal.service.EntidadeAiseService;
import br.com.elotech.portaltransparencia.contabportal.domain.PortalParametroContabil;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EntidadeAiseServiceImpl
implements EntidadeAiseService {
    private static final Long ENTIDADE_PADRAO = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(EntidadeAiseServiceImpl.class);
    private final PortalParametroRepository portalParametroRepository;

    public EntidadeAiseServiceImpl(PortalParametroRepository portalParametroRepository) {
        this.portalParametroRepository = portalParametroRepository;
    }

    public void setCodigoEntidadeAise(AiseParams aiseParams) {
        PortalParametroContabil parametro = this.getCodigoEntidadeAise(aiseParams.getEntidade());
        LOGGER.debug("Par\u00e2metro entidade do aise [{}]", (Object)parametro);
        if (Objects.nonNull(parametro) && parametro.isConfigurado().booleanValue()) {
            aiseParams.setEntidadeAise(Long.valueOf(Long.parseLong(parametro.getValor())));
        } else {
            aiseParams.setEntidadeAise(ENTIDADE_PADRAO);
        }
    }

    public PortalParametroContabil getCodigoEntidadeAise(Long entidade) {
        return this.portalParametroRepository.findOneByIdEntidadeAndIdExercicioAndIdId(entidade, Parametros.NAO_DEPENDE_EXERCICIO, Parametros.PARAM_ENTIDADE_AISE);
    }
}

