SELECT F.ENTIDADE,  
      TRIM(P.NOME) AS NOME,  
      F.MATRICULA,  
      (SELECT CASE
          WHEN SF.SITUACAO = 1 THEN 'ATIVO'
          WHEN SF.SITUACAO = 2 AND (EXISTS ( SELECT DISTINCT MA.ENTIDADE
             FROM RHMOVIMENTACAOAFASTAMENTO MA
            WHERE MA.ENTIDADE = SF.ENTIDADE AND MA.MATRICULA = SF.MATRICULA AND MA.DATAINICIAL = (( SELECT MAX(MA_1.DATAINICIAL) AS DATAINICIAL
                     FROM RHMOVIMENTACAOAFASTAMENTO MA_1
                    WHERE MA_1.ENTIDADE = SF.ENTIDADE AND MA_1.MATRICULA = SF.MATRICULA AND (MA_1.DATAFINAL >= FIMCOMPETENCIA(SF.ANOCOMPETENCIA, 12) OR MA_1.DATAFINAL IS NULL))))) THEN (('AFASTADO - ' || COALESCE(( SELECT A.DESCRICAO
             FROM RHAFASTAMENTO A
            WHERE A.ENTIDADE = SF.ENTIDADE AND A.AFASTAMENTO = (( SELECT MAX(MA.AFASTAMENTO) AS MAX
                     FROM RHMOVIMENTACAOAFASTAMENTO MA
                    WHERE MA.ENTIDADE = SF.ENTIDADE AND MA.MATRICULA = SF.MATRICULA AND MA.DATAINICIAL = (( SELECT MAX(MA_1.DATAINICIAL) AS DATAINICIAL
                             FROM RHMOVIMENTACAOAFASTAMENTO MA_1
                            WHERE MA_1.ENTIDADE = SF.ENTIDADE AND MA_1.MATRICULA = SF.MATRICULA AND (MA_1.DATAFINAL >= FIMCOMPETENCIA(SF.ANOCOMPETENCIA, 12) OR MA_1.DATAFINAL IS NULL)))))), ' ')) || ' ') || COALESCE(( SELECT DISTINCT 'LICENÇA PRÊMIO' AS TEXT
             FROM RHPROGRAMACAOPREMIO A
            WHERE A.ENTIDADE = SF.ENTIDADE AND A.MATRICULA = SF.MATRICULA AND A.FIMPECUNIA >= FIMCOMPETENCIA(SF.ANOCOMPETENCIA, 12) AND A.INICIOPECUNIA <= FIMCOMPETENCIA(SF.ANOCOMPETENCIA, 12) AND (A.FIMGOZO >= FIMCOMPETENCIA(SF.ANOCOMPETENCIA, 12) OR A.FIMGOZO IS NULL AND A.INICIOGOZO IS NOT NULL)), ' ')
          WHEN SF.SITUACAO = 3 AND (EXISTS ( SELECT MP.ENTIDADE
             FROM RHMOVIMENTACAOPESSOAL MP
               JOIN RHPROGRAMACAORESCISAO PR ON MP.ENTIDADE = PR.ENTIDADE AND MP.MATRICULA = PR.MATRICULA AND MP.MOVIMENTACAO = PR.MOVIMENTACAO
               JOIN RHRESCISAO R ON PR.ENTIDADE = R.ENTIDADE AND PR.RESCISAO = R.RESCISAO AND PR.CLASSE = R.CLASSE
            WHERE MP.ENTIDADE = SF.ENTIDADE AND MP.MATRICULA = SF.MATRICULA AND MP.TIPOMOVIMENTACAO = 7 AND (R.MOTIVO NOT IN (70, 71, 72, 73, 74, 75, 76, 77, 78, 79)))) THEN 'EXONERADO'
          WHEN SF.SITUACAO = 3 AND (EXISTS ( SELECT MP.ENTIDADE
             FROM RHMOVIMENTACAOPESSOAL MP
               LEFT JOIN RHPROGRAMACAORESCISAO PR ON MP.ENTIDADE = PR.ENTIDADE AND MP.MATRICULA = PR.MATRICULA AND MP.MOVIMENTACAO = PR.MOVIMENTACAO
               LEFT JOIN RHRESCISAO R ON PR.ENTIDADE = R.ENTIDADE AND PR.RESCISAO = R.RESCISAO AND PR.CLASSE = R.CLASSE
            WHERE MP.ENTIDADE = SF.ENTIDADE AND MP.MATRICULA = SF.MATRICULA AND ((MP.TIPOMOVIMENTACAO IN (8, 9, 10, 11)) OR MP.TIPOMOVIMENTACAO = 7 AND (R.MOTIVO IN (70, 71, 72, 73, 74, 75, 76, 77, 78, 79))))) THEN 'APOSENTADO'
          WHEN SF.SITUACAO = 3 THEN 'DEMITIDO'
          ELSE 'ATIVO'
       END AS SITUACAO
      FROM RHHISTORICOFUNCIONARIO SF
      WHERE SF.ANOCOMPETENCIA = :exercicio
        AND SF.ENTIDADE = F.ENTIDADE
        AND SF.MATRICULA = F.MATRICULA
        AND SF.TIPOFOLHA = FNC_GETTIPOFOLHAPRINCIPAL(F.ENTIDADE)
        AND SF.MESCOMPETENCIA = (( SELECT MAX(HFX.MESCOMPETENCIA) AS MAX
                                     FROM RHHISTORICOFUNCIONARIO HFX
                                    WHERE HFX.ENTIDADE = SF.ENTIDADE
                                      AND HFX.MATRICULA = SF.MATRICULA
                                      AND HFX.ANOCOMPETENCIA = SF.ANOCOMPETENCIA
                                      AND HFX.TIPOFOLHA = SF.TIPOFOLHA))) SITUACAO,
      F.DATAADMISSAO,
      CASE WHEN COALESCE(HF.SITUACAO, F.SITUACAO) = 3 THEN F.DATASITUACAO ELSE NULL END AS DATADEMISSAO,
      C.DESCRICAO AS DESCRICAOCARGO,  
      CL.DESCRICAO AS DESCRICAOCLASSE,  
      RDC.DESCRICAO AS DESCRICAONATUREZA,
      COALESCE(RLD.DESCRICAO, RL.DESCRICAO) AS DESCRICAOLOTACAO,
      COALESCE(HF.FAIXA, F.FAIXA) FAIXA,
      LOCALTRAB.DESCRICAO AS LOCALTRABALHO,
      COALESCE(F.HORASSEMANAIS, C.HORASSEMANAIS) AS HORASSEMANAIS,
      HOR.ENTRADA AS HORARIOENTRADA,
      HOR.SAIDAINTERVALO AS HORARIOSAIDAINTERVALO,
      HOR.ENTRADAINTERVALO AS HORARIOENTRADAINTERVALO,
      HOR.SAIDA AS HORARIOSAIDA,
      HOR.PERMITEFLEXIBILIDADE AS HORARIOESPECIAL,
  (SELECT COALESCE(MAX(CN.DESCRICAO || ' - ' || COALESCE(FC.FAIXA, '')),
                   MAX(FC.DESCRICAO || ' - ' || COALESCE(FC.FAIXA, ''))) 
     FROM RHMOVIMENTACAOPESSOAL MP
    JOIN RHTIPOMOVIMENTACAO TM
      ON MP.TIPOMOVIMENTACAO = TM.TIPOMOVIMENTACAO
    JOIN RHMOVIMENTACAOOUTROS MO
      ON MP.ENTIDADE = MO.ENTIDADE
     AND MP.MATRICULA = MO.MATRICULA
     AND MP.MOVIMENTACAO = MO.MOVIMENTACAO
    LEFT OUTER JOIN RHCARGO CN
      ON CN.ENTIDADE = MO.ENTIDADE
     AND CN.CARGO = MO.CARGO
    LEFT OUTER JOIN RHFUNCAO FC
      ON MO.ENTIDADE = FC.ENTIDADE
     AND MO.FUNCAO = FC.FUNCAO
    WHERE F.ENTIDADE = MP.ENTIDADE
	  AND F.MATRICULA = MP.MATRICULA
      AND (((MP.TIPOMOVIMENTACAO IN (59, 60, 102))
           AND (MO.OPCAOSALARIO IN ('N', 'D', 'C')))
            OR (MP.TIPOMOVIMENTACAO IN (45, 58, 99)))
	  AND (MO.OPCAOSALARIO IS NULL OR MO.OPCAOSALARIO <> 'O')
	  AND ((:exercicio < EXTRACT(YEAR FROM CAST(:dataAtual AS DATE))
	  AND MO.DATAINICIO <= FIMCOMPETENCIA(:exercicio, 12)
	  AND (MO.DATAFIM IS NULL OR MO.DATAFIM >= FIMCOMPETENCIA(:exercicio, 12))) 
	   OR (:exercicio = EXTRACT(YEAR FROM CAST(:dataAtual as date)) 
	  AND MO.DATAINICIO <= :dataAtual
	  AND (MO.DATAFIM IS NULL OR MO.DATAFIM >= :dataAtual)))
   ) NOMEACAO,
   (SELECT MAX(CASE WHEN ML.TIPOBENEFICIO = 'N' THEN 'CEDIDO SEM ÔNUS - ' || Coalesce(P.NOME,' ')
        ELSE 'CEDIDO COM ÔNUS - ' || Coalesce(P.NOME,' ') END)
     FROM RHMOVIMENTACAOPESSOAL MP
     JOIN RHTIPOMOVIMENTACAO TM
       ON MP.TIPOMOVIMENTACAO = TM.TIPOMOVIMENTACAO
     JOIN RHMOVIMENTACAOLEGAL ML
       ON MP.ENTIDADE = ML.ENTIDADE
      AND MP.MATRICULA = ML.MATRICULA
      AND MP.MOVIMENTACAO = ML.MOVIMENTACAO
     LEFT OUTER JOIN PESSOA P
       ON ML.PESSOA = P.PESSOA
    WHERE F.ENTIDADE = MP.ENTIDADE
      AND F.MATRICULA = MP.MATRICULA
      AND MP.TIPOMOVIMENTACAO = 90
	  AND ((:exercicio < EXTRACT(YEAR FROM CAST(:dataAtual AS DATE))
	  AND ML.DATABENEFICIO <= FIMCOMPETENCIA(:exercicio, 12)
	  AND (ML.DATATERMINO IS NULL OR ML.DATATERMINO >= FIMCOMPETENCIA(:exercicio, 12))) 
	   OR (:exercicio = EXTRACT(YEAR FROM CAST(:dataAtual as date)) 
	  AND ML.DATABENEFICIO <= :dataAtual
	  AND (ML.DATATERMINO IS NULL OR ML.DATATERMINO >= :dataAtual)))
   ) CEDIDO,
   (SELECT MAX(CASE WHEN MA.TIPO = '6' THEN 'CEDIDO SEM ÔNUS - ' || Coalesce(P.NOME,' ')
     ELSE 'CEDIDO COM ÔNUS - ' || Coalesce(P.NOME,' ') END)
     FROM RHMOVIMENTACAOPESSOAL MP
     JOIN RHTIPOMOVIMENTACAO TM
       ON MP.TIPOMOVIMENTACAO = TM.TIPOMOVIMENTACAO
     JOIN RHMOVIMENTACAOAFASTAMENTO MA
       ON MP.ENTIDADE = MA.ENTIDADE
      AND MP.MATRICULA = MA.MATRICULA
      AND MP.MOVIMENTACAO = MA.MOVIMENTACAO
     LEFT OUTER JOIN PESSOA P
       ON MA.PESSOA = P.PESSOA
    WHERE F.ENTIDADE = MP.ENTIDADE
      AND F.MATRICULA = MP.MATRICULA
      AND MP.TIPOMOVIMENTACAO = 23
	  AND ((:exercicio < EXTRACT(YEAR FROM CAST(:dataAtual AS DATE))
	  AND MA.DATAINICIAL <= FIMCOMPETENCIA(:exercicio, 12)
	  AND (MA.DATAFINAL IS NULL OR MA.DATAFINAL >= FIMCOMPETENCIA(:exercicio, 12))) 
	   OR (:exercicio = EXTRACT(YEAR FROM CAST(:dataAtual as date)) 
	  AND MA.DATAINICIAL <= :dataAtual
	  AND (MA.DATAFINAL IS NULL OR MA.DATAFINAL >= :dataAtual)))
   ) CEDIDOPARA,
   (SELECT COALESCE(MAX(RENOVACAOFINAL), MAX(DATAFINALCONTRATO))
      FROM RHMOVIMENTACAOPESSOAL MP
      JOIN RHCONTRATOPRAZODETERMINADO CPD
        ON MP.ENTIDADE = CPD.ENTIDADE
       AND MP.MATRICULA = CPD.MATRICULA
       AND MP.MOVIMENTACAO = CPD.MOVIMENTACAO
     WHERE MP.ENTIDADE = F.ENTIDADE
       AND MP.MATRICULA = F.MATRICULA
       AND MP.TIPOMOVIMENTACAO IN (35, 73)) DATAFIMCONTRATO,
   CASE WHEN CL.DEFINICAO = 1 OR EXISTS(SELECT 1 
                     FROM RHMOVIMENTACAOPESSOAL MP 
					WHERE MP.ENTIDADE = F.ENTIDADE 
					  AND MP.MATRICULA = F.MATRICULA   
					  AND MP.TIPOMOVIMENTACAO = 1) THEN 'Concurso Público'
		WHEN CL.DEFINICAO = 2 OR (CL.DEFINICAO = 5 AND EXISTS(SELECT 1
                                           FROM RHCONTRATOPRAZODETERMINADO CPD
                                          WHERE CPD.ENTIDADE = F.ENTIDADE
										    AND CPD.MATRICULA = F.MATRICULA
											AND CPD.DATAINICIOCONTRATO <= FIMCOMPETENCIA(:exercicio, 12)
                                            AND (((:exercicio >= EXTRACT(YEAR FROM CAST(:dataAtual AS DATE))) AND ((COALESCE(CPD.RENOVACAOFINAL, CPD.DATAFINALCONTRATO) IS NULL) OR (COALESCE(CPD.RENOVACAOFINAL, CPD.DATAFINALCONTRATO) > :dataAtual)))
                                             OR  ((:exercicio <  EXTRACT(YEAR FROM CAST(:dataAtual AS DATE))) AND ((COALESCE(CPD.RENOVACAOFINAL, CPD.DATAFINALCONTRATO) IS NULL) OR (COALESCE(CPD.RENOVACAOFINAL, CPD.DATAFINALCONTRATO) >= INICIOCOMPETENCIA(:exercicio, 1))))))) THEN 'Processo Seletivo' 
		ELSE 'Livre Nomeação' END FORMAINVESTIDURA,
    CL.EXIBECARGAHORARIAPORTALTRANSP EXIBECARGAHORARIA,
	COALESCE(GOF.VALOR, (SELECT MAX(FFX.BASECALCULO)
						   FROM RHFICHAFINANCEIRA FFX
						   JOIN RHEVENTO EVX
							 ON FFX.ENTIDADE = EVX.ENTIDADE
						    AND FFX.EVENTO = EVX.EVENTO
						  WHERE FFX.ENTIDADE = F.ENTIDADE
							AND FFX.MATRICULA = F.MATRICULA
							AND FFX.ANOCOMPETENCIA = :exercicio
							AND EVX.DEFINICAO = 1)) SALARIOBASE
   FROM RHFUNCIONARIO F  
   LEFT OUTER JOIN RHHISTORICOFUNCIONARIO HF
     ON F.ENTIDADE = HF.ENTIDADE
    AND F.MATRICULA = HF.MATRICULA
    AND HF.TIPOFOLHA = FNC_GETTIPOFOLHAPRINCIPAL(F.ENTIDADE)
    AND HF.ANOCOMPETENCIA = :exercicio
    AND HF.MESCOMPETENCIA = 12
   LEFT OUTER JOIN PESSOA  P   
     ON F.PESSOA = P.PESSOA  
   LEFT OUTER JOIN RHCARGO C   
     ON F.ENTIDADE = C.ENTIDADE     
    AND COALESCE(HF.CARGO, F.CARGO) = C.CARGO    
   LEFT OUTER JOIN RHCLASSE CL   
     ON F.ENTIDADE = CL.ENTIDADE     
    AND COALESCE(HF.CLASSE, F.CLASSE) = CL.CLASSE    
   LEFT OUTER JOIN RHDEFINICAOCLASSE RDC       
     ON CL.DEFINICAO = RDC.DEFINICAO     
   LEFT OUTER JOIN RHLOTACAO RL       
     ON F.ENTIDADE = RL.ENTIDADE      
    AND COALESCE(HF.MODELOLOTACAO, F.MODELOLOTACAO) = RL.MODELOLOTACAO      
    AND COALESCE(HF.NIVELLOTACAO, F.NIVELLOTACAO) = RL.NIVELLOTACAO      
    AND COALESCE(HF.LOTACAO, F.LOTACAO) = RL.LOTACAO  	
   LEFT OUTER JOIN RHMODELOLOTACAO ML
     ON COALESCE(HF.MODELOLOTACAO, F.MODELOLOTACAO) = ML.MODELOLOTACAO
   LEFT OUTER JOIN RHNIVELMODELOLOTACAO NML
     ON ML.MODELOLOTACAO = NML.MODELOLOTACAO
    AND ML.NIVELDESCRICAOPORTALTRANSP = NML.NIVELLOTACAO
   LEFT OUTER JOIN RHLOTACAO RLD
     ON F.ENTIDADE = RLD.ENTIDADE
    AND COALESCE(HF.MODELOLOTACAO, F.MODELOLOTACAO) = RLD.MODELOLOTACAO
    AND NML.NIVELLOTACAO = RLD.NIVELLOTACAO
    AND COALESCE(HF.NIVELLOTACAO, F.NIVELLOTACAO) > NML.NIVELLOTACAO
    AND RLD.LOTACAO = SUBSTR(COALESCE(HF.LOTACAO, F.LOTACAO), 1, (NML.POSICAO + NML.TAMANHO) - 1)		
  LEFT OUTER JOIN RHLOCALDETRABALHO LOCALTRAB
    ON COALESCE(HF.LOCALDETRABALHO, F.LOCALDETRABALHO) = LOCALTRAB.LOCALDETRABALHO
  LEFT OUTER JOIN RHHORARIOTRABALHO HOR
    ON F.ENTIDADE = HOR.ENTIDADE
   AND COALESCE(HF.HORARIOTRABALHO, F.HORARIOTRABALHO) = HOR.HORARIOTRABALHO
  LEFT OUTER JOIN RHGRUPOOCUPACIONALFAIXA GOF
    ON F.ENTIDADE = GOF.ENTIDADE
   AND COALESCE(HF.QUADROSALARIAL, F.QUADROSALARIAL) = GOF.QUADROSALARIAL
   AND COALESCE(HF.GRUPOOCUPACIONAL, F.GRUPOOCUPACIONAL) = GOF.GRUPOOCUPACIONAL
   AND COALESCE(HF.NIVEL, F.NIVEL) = GOF.NIVEL
   AND COALESCE(HF.FAIXA, F.FAIXA) = GOF.FAIXA
   AND EXTRACT(YEAR FROM GOF.INICIOVALIDADE) <= :exercicio
  WHERE F.ENTIDADE = :entidade
    AND ((F.SITUACAO <> 3) OR (F.SITUACAO = 3 AND F.DATASITUACAO >= INICIOCOMPETENCIA(:exercicio,01)))
    AND EXTRACT(YEAR FROM F.DATAADMISSAO) <= :exercicio
	AND ((GOF.ENTIDADE IS NULL) OR 
	     (GOF.INICIOVALIDADE = (SELECT MAX(GOFX.INICIOVALIDADE)
                                  FROM RHGRUPOOCUPACIONALFAIXA GOFX
                                 WHERE GOFX.ENTIDADE = GOF.ENTIDADE
                                   AND GOFX.QUADROSALARIAL = GOF.QUADROSALARIAL
                                   AND GOFX.GRUPOOCUPACIONAL = GOF.GRUPOOCUPACIONAL
                                   AND GOFX.NIVEL = GOF.NIVEL
                                   AND GOFX.FAIXA = GOF.FAIXA
                                   AND GOFX.INICIOVALIDADE <= CAST(:exercicio || '-12-01' AS DATE))))