SELECT XX.*
  FROM (
SELECT FR.FONTERECURSO||' - '||FR.DESCRICAO AS FONTERECURSO,
       P.DATA,
       L.EXERCICIO AS EXERCICIOLIQUIDACAO,
       L.NOLIQUIDACAO,
       E.ENTIDADE,
       E.EXERCICIO,
       E.EMPENHO,
       E.EMPENHO||'/'||E.EXERCICIO AS EMPENHOEXERCICIO,
       TL.DESCRICAO AS TIPOLICITACAO,
       E.NOLICITACAO||'/'||E.ANOLICITACAO AS LICITACAO,
       CASE WHEN F.TIPOPESSOA = 'F' THEN '****' || SUBSTR(F.CNPJ, 5, 3) || '****' || ' - ' || F.NOME 
			ELSE SUBSTR(F.CNPJ,1,2) || '.' || SUBSTR(F.CNPJ,3,3) || '.' || SUBSTR(F.CNPJ,6,3) || '/' || SUBSTR(F.CNPJ,9,4) || '-' || SUBSTR(F.CNPJ,13,2) || ' - ' || F.NOME
	   END AS FORNECEDOR,
       L.VALOR,
       L.VALOR AS SALDO,
       E.NOPROCESSO||'/'||E.ANOPROCESSO AS PROCESSO,
	   L.VALOR + COALESCE((SELECT  SUM(RETLIQ.VALOR)
							 FROM  RETENCOESLIQUIDACAO RETLIQ
							 JOIN  PARAMETROS PARAM
							   ON  PARAM.ENTIDADE   = RETLIQ.ENTIDADE
							  AND  PARAM. EXERCICIO = RETLIQ.EXERCICIO
							  AND  PARAM.MODULO     = '3'
							  AND  PARAM.CODIGO     = 18
							  AND  PARAM.VALOR      = 'L'
							WHERE  RETLIQ.ENTIDADE         = L.ENTIDADE
							AND    RETLIQ.EXERCICIO 	   = L.EXERCICIO
							AND    RETLIQ.NOLIQUIDACAO     = L.NOLIQUIDACAO
							AND    RETLIQ.TIPODOCORIGEM    = 'E'
							AND    RETLIQ.ANODOCORIGEM     = L.ANODOCORIGEM
							AND    RETLIQ.NODOCORIGEM      = L.NODOCORIGEM
							AND    RETLIQ.UNIDADEDOCORIGEM = L.UNIDADEDOCORIGEM),0) + COALESCE((SELECT  SUM(RETPAG.VALOR)
																								  FROM  ORDEMPAGAMENTO_RETENCAO RETPAG
																								  JOIN   PARAMETROS PARAM
																									ON   PARAM.ENTIDADE   = RETPAG.ENTIDADE
																								   AND   PARAM. EXERCICIO = RETPAG.EXERCICIO
																								   AND   PARAM.MODULO     = '3'
																								   AND   PARAM.CODIGO     = 18
																								   AND   PARAM.VALOR      = 'P'
																								 WHERE  RETPAG.ENTIDADE   = L.ENTIDADE
																								 AND    RETPAG.EXERCICIO  = L.EXERCICIO
																								 AND    RETPAG.NOORDEM    = L.NOORDEM
																								 AND    RETPAG.SEQUENCIA  = L.SEQUENCIA ),0)  AS VALORPARAMETRO
  FROM ORDEMPAGAMENTO_LIQUIDACAO L
 INNER JOIN PAGAMENTO P
    ON L.ENTIDADE = P.ENTIDADE
   AND L.EXERCICIO = P.ANOORDEMPAGAMENTO
   AND L.NOORDEM = P.NOORDEMPAGAMENTO
   AND P.ESTORNO = 'N'
  LEFT OUTER JOIN EMPENHO E
    ON L.ENTIDADE = E.ENTIDADE
   AND L.ANODOCORIGEM = E.EXERCICIO
   AND L.NODOCORIGEM = E.EMPENHO
   AND L.UNIDADEDOCORIGEM = E.UNIDADEORCAMENTARIA
   AND E.CONTABILIZADO = 'S'
  LEFT OUTER JOIN FONTERECURSO FR
    ON E.FONTERECURSO = FR.FONTERECURSO     
  LEFT OUTER JOIN TIPOSLICITACAO TL
    ON E.TIPOLICITACAO = TL.TIPOLICITACAO
  LEFT OUTER JOIN FORNECEDOR F
    ON E.FORNECEDOR = F.FORNECEDOR
       $[FILTRO]) XX