SELECT Y.*, 
       CASE WHEN Y.VALORRESTITUIDOSUB < 0 THEN 0 
            ELSE Y.VALORRESTITUIDOSUB 
        END VALORRESTITUIDO,
       CASE WHEN (Y.VALORDOCUMENTOS + Y.RECEITAVALOR) - Y.VALORPRESTAR < 0 THEN 0
            ELSE (Y.VALORDOCUMENTOS + Y.RECEITAVALOR) - Y.VALORPRESTAR  
        END VALOREXCEDIDO
  FROM (SELECT A.ENTIDADE, 
				A.EXERCICIO, 
				A.PRESTACAOCONTAS,
				F.NOME, 
				A.DATA AS DATAPRESTACAO, 
				A.EMPENHO, 
				A.EXERCICIOEMPENHO, 
				E.DATA AS DATAEMPENHO, 
				A.VALOREMPENHO, 
				COALESCE((SELECT SUM(VALORPAGAMENTO -VALORESTPAGAMENTO)
							FROM FICHAEMPENHO FE 
						   WHERE FE.ENTIDADE  = A.ENTIDADE
							AND FE.EXERCICIO = A.EXERCICIOEMPENHO
							AND FE.EMPENHO   = A.EMPENHO),0) AS VALORPAGO,
				COALESCE((SELECT SUM(DOC.VALOR) 
							FROM PRESTACAOCONTASDOCUMENTO DOC
							WHERE A.ENTIDADE = DOC.ENTIDADE
							AND A.EXERCICIO = DOC.EXERCICIO
							AND A.PRESTACAOCONTAS = DOC.PRESTACAOCONTAS
							AND DOC.TIPODOCUMENTO <> 99),0) AS VALORDOCUMENTOS,
				A.VALOREMPENHO - COALESCE((SELECT SUM(DOC.VALOR) 
											FROM PRESTACAOCONTASDOCUMENTO DOC
											WHERE A.ENTIDADE = DOC.ENTIDADE
											AND A.EXERCICIO = DOC.EXERCICIO
											AND A.PRESTACAOCONTAS = DOC.PRESTACAOCONTAS
											AND DOC.TIPODOCUMENTO <> 99),0) AS VALORRESTITUIDOSUB,   
				COALESCE((SELECT VALOR
							FROM PAGAMENTO P 
							WHERE P.ENTIDADE  = A.ENTIDADE
							AND P.EXERCICIO = A.EXERCICIOEMPENHO
							AND P.NOPAGAMENTO = A.NOPAGAMENTO),0) - COALESCE((SELECT SUM(DOC.VALOR) 
																				FROM PRESTACAOCONTASDOCUMENTO DOC, 
																									PRESTACAOCONTAS B   
																				WHERE DOC.ENTIDADE = B.ENTIDADE
																				AND DOC.EXERCICIO = B.EXERCICIO
																				AND DOC.PRESTACAOCONTAS = B.PRESTACAOCONTAS 
																				AND B.ENTIDADE = A.ENTIDADE
																				AND B.EXERCICIOEMPENHO = A.EXERCICIOEMPENHO
																				AND B.EMPENHO = A.EMPENHO 
																				AND B.EXERCICIO = A.EXERCICIO
																				AND B.NOPAGAMENTO = A.NOPAGAMENTO
																				AND B.CONTABILIZADO = 'S'
																				AND B.PRESTACAOCONTAS <> A.PRESTACAOCONTAS),0) VALORPRESTAR,
				A.CARGO,
				A.LOTACAO,
				CAST(' ' AS VARCHAR(10)) AS UNIDADEORCAMENTARIA,
				0 AS NOLIQUIDACAO,
				CAST(' ' AS VARCHAR(10)) AS MATRICULA,
				A.EMPENHO_VLREXCEDIDO AS EMPENHOEXCEDIDO,
				A.EXERCICIOEMPENHO_VLREXCEDIDO AS EXERCICIOEMPENHOEXCEDIDO,
				COALESCE(A.RECEITAVALOR,0) RECEITAVALOR
	FROM PRESTACAOCONTAS A
INNER JOIN EMPENHO E 
			ON A.ENTIDADE = E.ENTIDADE
		AND A.EXERCICIOEMPENHO = E.EXERCICIO
		AND A.EMPENHO = E.EMPENHO
		AND A.UNIDADEORCAMENTARIA = E.UNIDADEORCAMENTARIA
	LEFT OUTER JOIN FORNECEDOR F 
			ON E.FORNECEDOR = F.FORNECEDOR
  WHERE A.ENTIDADE = :entidade
  AND A.EXERCICIO = :exercicio