SELECT A.ENTIDADE, A.EXERCICIO, A.IDORDEMSERVICO, A.ORDEMSERVICO, A.BEMPROPRIO AS DESCRICAOBEM,
 A.DESCRICAO, A.BEM,
 A.VALOR AS VALORINTERVENCAO,
 C.VALOR AS VALORCONTRATO,
 P.NOME AS EMPRESA,
 ((SELECT SUM(COALESCE(AD.VALOR,0) - COALESCE(AD.VALORREDUCAO,0))
    FROM OBRAEMPRESACONTRATOADITIVO AD
   WHERE C.IDEMPRESACONTRATO = AD.IDEMPRESACONTRATO)) AS VALORADITIVO,
 ((SELECT SUM(COALESCE(AC.VALORFATURAMENTO,0) + COALESCE(AC.VALORCONVENIO,0))
    FROM OBRAACOMPANHAMENTO AC
   WHERE A.ENTIDADE = AC.ENTIDADE
     AND A.EXERCICIO = AC.EXERCICIO
     AND A.IDORDEMSERVICO = AC.IDORDEMSERVICO)) AS VALORPAGO,
 A.DATAINICIO AS DATA,
 T.IDTIPOACOMPANHAMENTO AS SITUACAO, 
 A.PERCENTUAL,
 A.OBJETO,
 C.NOCONTRATO AS NUMEROCONTRATO,
 C.EXERCICIOCONTRATO,
 C.IDCONTRATO,
 (SELECT COALESCE(COUNT(*),0) FROM OBRAORDEMPLANILHAORCAMENTO B
   WHERE B.ENTIDADE = A.ENTIDADE
   AND B.EXERCICIO = A.EXERCICIO
   AND B.IDORDEMSERVICO = A.IDORDEMSERVICO) AS EXISTEPLANILHA  
 FROM OBRAORDEMSERVICO A
 LEFT OUTER JOIN OBRABEM B ON
      A.ENTIDADE = B.ENTIDADE
      AND A.BEM = B.BEM
 LEFT OUTER JOIN OBRAEMPRESACONTRATO C ON
      A.IDEMPRESACONTRATO = C.IDEMPRESACONTRATO
 LEFT OUTER JOIN PESSOA P ON
      A.CONSTRUTORA = P.PESSOA
 LEFT OUTER JOIN OBRATIPOACOMPANHAMENTO T ON 
   A.IDTIPOACOMPANHAMENTO = T.IDTIPOACOMPANHAMENTO
 WHERE A.ENTIDADE = :entidade
  AND EXTRACT(YEAR FROM A.DATAINICIO) <= :exercicio
  AND (A.IDTIPOACOMPANHAMENTO NOT IN (3,4,5)
        or exists( select * FROM OBRAACOMPANHAMENTO OA
                   WHERE OA.IDORDEMSERVICO = A.IDORDEMSERVICO
                     AND OA.ENTIDADE = A.ENTIDADE
                     AND OA.EXERCICIO = A.EXERCICIO
                     AND EXTRACT(YEAR from OA.data) = :exercicio ) )
   AND A.VINCULADOTCE = 'S'
   
