/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service.impl;

import br.com.elotech.portaltransparencia.arquivoportal.service.ArquivoService;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ObjetivoEstrategicoArqDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ObjetivoEstrategicoDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.ObjetivoEstrategicoRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.ObjetivoEstrategicoParams;
import br.com.elotech.portaltransparencia.contabportal.service.ObjetivoEstrategicoService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ObjetivoEstrategicoServiceImpl
implements ObjetivoEstrategicoService {
    private final ObjetivoEstrategicoRepository objetivoEstrategicoRespository;
    private final ArquivoService arquivoService;

    @Autowired
    public ObjetivoEstrategicoServiceImpl(ObjetivoEstrategicoRepository objetivoEstrategicoRespository, ArquivoService arquivoService) {
        this.objetivoEstrategicoRespository = objetivoEstrategicoRespository;
        this.arquivoService = arquivoService;
    }

    public List<ObjetivoEstrategicoDTO> findObjetivoEstrategico(ObjetivoEstrategicoParams params) {
        List listaObjetivos = this.objetivoEstrategicoRespository.findObjetivoEstrategico(params);
        for (ObjetivoEstrategicoDTO objetivoEstrategico : listaObjetivos) {
            ObjetivoEstrategicoParams paramObj = ObjetivoEstrategicoParams.builder().entidade(objetivoEstrategico.getEntidade()).exercicio(objetivoEstrategico.getExercicio()).objCodigo(objetivoEstrategico.getObjCodigo()).build();
            List arquivos = this.objetivoEstrategicoRespository.findObjetivoEstrategicoArq(paramObj);
            for (ObjetivoEstrategicoArqDTO arquivo : arquivos) {
                Long tamanhoArquivo = this.arquivoService.getTamanhoArquivo(arquivo.getIdArquivo());
                arquivo.setTamanhoArquivo(tamanhoArquivo);
            }
            objetivoEstrategico.setArquivos(arquivos);
        }
        return listaObjetivos;
    }
}

