/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.DespesaDetalhadaDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.DespesaPorNivelDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.DespesaParams;
import br.com.elotech.portaltransparencia.contabportal.service.DespesaPorNivelService;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/despesapornivel"})
public class DespesaPorNivelResource {
    private final DespesaPorNivelService despesaPorNivelService;
    private final BaseExport baseExport;
    private final EntidadeContabilidadeRepository entidadeRepository;

    public DespesaPorNivelResource(DespesaPorNivelService despesaPorNivelService, BaseExport baseExport, EntidadeContabilidadeRepository entidadeRepository) {
        this.despesaPorNivelService = despesaPorNivelService;
        this.baseExport = baseExport;
        this.entidadeRepository = entidadeRepository;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{entidade}/{exercicio}/{nivelLei}/{tipo}"})
    public ResponseEntity<List<DespesaPorNivelDTO>> getDespesaPorNivel(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable String nivelLei, @PathVariable String tipo) {
        return ResponseEntity.ok((Object)this.despesaPorNivelService.getDespesaPorNivel(entidade, exercicio, nivelLei, tipo));
    }

    @GetMapping(value={"/fonte-recursos"})
    public ResponseEntity<List<DespesaPorNivelDTO>> getDepesaPorFonteRecursos(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio) {
        return ResponseEntity.ok((Object)this.despesaPorNivelService.getDespesaPorFonteRecurso(entidade, exercicio));
    }

    @GetMapping(value={"/esfera-administrativa"})
    public ResponseEntity<List<DespesaPorNivelDTO>> getDepesaPorEsferaAdministrativa(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio) {
        return ResponseEntity.ok((Object)this.despesaPorNivelService.getDespesaPorEsferaAdministrativa(entidade, exercicio));
    }

    @GetMapping(value={"/detalhada"})
    public ResponseEntity<List<DespesaDetalhadaDTO>> getDepesaDetalhada(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio) {
        return ResponseEntity.ok((Object)this.despesaPorNivelService.getDepesaDetalhada(entidade, exercicio));
    }

    @GetMapping(value={"/nivel"})
    public ResponseEntity<List<DespesaDetalhadaDTO>> getDepesaAgrupaNivel(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, DespesaParams params) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.despesaPorNivelService.getDepesaAgrupaNivel(params));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/report/{entidade}/{exercicio}/{nivelLei}/{tipo}/{exportType}"})
    public ModelAndView despesaPorNivelExport(HttpServletRequest request, HttpServletResponse response, @PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable String nivelLei, @PathVariable String tipo, @PathVariable String exportType) throws Throwable {
        PageImpl page = new PageImpl(this.despesaPorNivelService.getDespesaPorNivel(entidade, exercicio, nivelLei, tipo));
        Entidade entidadeObj = (Entidade)this.entidadeRepository.findOne((Object)entidade);
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setReportTitle(String.format("Despesas por %s", this.getDescricaoNivelLei(nivelLei)));
        reportParam.setClazzDTO(DespesaPorNivelDTO.class);
        reportParam.setHeaderFields("C\u00f3digo,Descri\u00e7\u00e3o,Valor Or\u00e7ado,Valor Empenhado,Valor Liquidado,Valor Retido,Valor Pago");
        reportParam.setFields("codigo,descricao,valorOrcado,valorEmpenhado,valorLiquidado,valorRetido,valorPago");
        float[] fieldsPerc = new float[]{1.0f, 3.0f, 1.2f, 1.2f, 1.2f, 1.2f, 1.2f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{15, 200, 20, 20, 20, 20, 20};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setPage((Page)page);
        reportParam.setSumFields("valorOrcado,valorEmpenhado,valorLiquidado,valorRetido,valorPago");
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(exportType);
        return this.baseExport.toExport(reportParam);
    }

    private String getDescricaoNivelLei(String nivelLei) {
        switch (nivelLei) {
            case "O": {
                return "Org\u00e3o";
            }
            case "F": {
                return "Fun\u00e7\u00e3o";
            }
            case "P": {
                return "Programa";
            }
            case "PA": {
                return "Projeto Atividade";
            }
            case "N": {
                return "Elemento";
            }
        }
        return null;
    }
}

