/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.config;

import br.com.elotech.portaltransparencia.contabportal.domain.ConfiguracaoInterface;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.service.ConfiguracaoService;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EntidadeResolver {
    private final ConfiguracaoService configuracaoService;
    private final EntidadeContabilidadeService entidadeService;

    @Autowired
    public EntidadeResolver(ConfiguracaoService configuracaoService, EntidadeContabilidadeService entidadeService) {
        this.configuracaoService = configuracaoService;
        this.entidadeService = entidadeService;
    }

    public String resolve(Long entidade) {
        if (entidade.equals(-1L)) {
            Optional<ConfiguracaoInterface> configuracao = Optional.ofNullable(this.configuracaoService.getConfiguracao());
            return "NOT IN (" + configuracao.get().getNaoMostrarEntidade() + ")";
        }
        return " = :entidade";
    }

    public Long getEntidadePadrao(Long entidade) {
        if (entidade.equals(-1L)) {
            return ((Entidade)this.entidadeService.getEntidadePrincipal().get()).getId();
        }
        return entidade;
    }
}

