/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.arquivoportal.service;

import br.com.elotech.core.config.DBConfigProperties;
import br.com.elotech.portaltransparencia.arquivoportal.domain.Arquivo;
import br.com.elotech.portaltransparencia.arquivoportal.domain.ArquivoContent;
import br.com.elotech.portaltransparencia.arquivoportal.domain.ArquivoInterface;
import br.com.elotech.portaltransparencia.arquivoportal.repository.EloArquivoRepository;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ArquivoService {
    public static final String SCHEMA_ELOARQUIVO = "schema_eloarquivo";
    private static final Long MAX_SIZE_POOL = 0xA00000L;
    private final EloArquivoRepository arquivoRepository;
    private final DBConfigProperties dbConfigProperties;

    @Autowired
    public ArquivoService(EloArquivoRepository arquivoRepository, DBConfigProperties dbConfigProperties) {
        this.arquivoRepository = arquivoRepository;
        this.dbConfigProperties = dbConfigProperties;
    }

    public ArquivoInterface getArquivoInterface(Long id) {
        return this.arquivoRepository.findByIdProjection(id);
    }

    public Arquivo findOne(Long id) {
        return (Arquivo)this.arquivoRepository.findOne((Object)id);
    }

    public Long getTamanhoArquivo(Long id) {
        return this.arquivoRepository.getTamanhoArquivo(id);
    }

    public String getNomeSchemaEloArquivo() {
        if (Objects.nonNull(this.dbConfigProperties.getEloarquivo()) && StringUtils.isNotBlank((String)this.dbConfigProperties.getEloarquivo().getSchema())) {
            return this.dbConfigProperties.getEloarquivo().getSchema();
        }
        return "ELOARQUIVO";
    }

    public Arquivo save(Arquivo arquivo) {
        return (Arquivo)this.arquivoRepository.save((Object)arquivo);
    }

    public void remove(Long id) {
        this.arquivoRepository.deleteById((Object)id);
    }

    public Arquivo findArquivoByPart(Long id) {
        Long tamanhoTotal = this.arquivoRepository.getTamanhoBytes(id);
        if (tamanhoTotal > MAX_SIZE_POOL) {
            String nome = this.arquivoRepository.getNameArquivo(id);
            Long posIni = 1L;
            Long posFim = MAX_SIZE_POOL;
            ByteBuffer allBytes = ByteBuffer.allocate(tamanhoTotal.intValue());
            while (posIni <= tamanhoTotal) {
                byte[] partBytes = posFim > tamanhoTotal ? this.arquivoRepository.getPartBytes(id, Integer.valueOf(posIni.intValue()), Integer.valueOf(tamanhoTotal.intValue() - posIni.intValue())) : this.arquivoRepository.getPartBytes(id, Integer.valueOf(posIni.intValue()), Integer.valueOf(MAX_SIZE_POOL.intValue()));
                allBytes.put(partBytes);
                posIni = posIni + MAX_SIZE_POOL;
                posFim = posIni + MAX_SIZE_POOL;
            }
            ArquivoContent content = new ArquivoContent();
            content.setBinary(allBytes.array());
            Arquivo arquivo = new Arquivo();
            arquivo.setId(id);
            arquivo.setNome(nome);
            arquivo.setContent(content);
            return arquivo;
        }
        return (Arquivo)this.arquivoRepository.findOne((Object)id);
    }
}

