/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.service.impl;

import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.repository.PortalParametroRepository;
import br.com.elotech.portaltransparencia.aiseportal.service.EntidadeProtocoloService;
import br.com.elotech.portaltransparencia.contabportal.domain.PortalParametroContabil;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;

@Service
public class EntidadeProtocoloServiceImpl
implements EntidadeProtocoloService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntidadeProtocoloServiceImpl.class);
    @Autowired
    private PortalParametroRepository portalParametroRepository;

    public Long getCodigoEntidadeProtocolo(Long entidade) {
        try {
            PortalParametroContabil parametro = this.findCodigoEntidadeProtocolo(entidade);
            if (Objects.nonNull(parametro) && StringUtils.isNotBlank((String)parametro.getValor())) {
                return Long.parseLong(parametro.getValor());
            }
        }
        catch (DataAccessException e) {
            LOGGER.error(e.getMessage());
        }
        return entidade;
    }

    private PortalParametroContabil findCodigoEntidadeProtocolo(Long entidadeSiscop) {
        return this.portalParametroRepository.findOneByIdEntidadeAndIdExercicioAndIdId(entidadeSiscop, Parametros.NAO_DEPENDE_EXERCICIO, Parametros.PARAM_ENTIDADE_PROTOCOLO);
    }
}

