SELECT EX.MES, 
   (SELECT COALESCE(SUM(RD.VALORARRECADADO-RD.VALORESTARRECADADO-RD.VALORDEVOLUCAO+RD.VALORESTDEVOLUCAO),0) 
           FROM RECEITADIARIA RD 
           LEFT OUTER JOIN RECEITA R 
             ON RD.ENTIDADE = R.ENTIDADE 
            AND RD.EXERCICIO = R.EXERCICIO 
            AND RD.RECEITA = R.RECEITA 
            AND RD.FONTERECURSO = R.FONTERECURSO 
            AND RD.IDTIPOOPERACAORECEITA = R.IDTIPOOPERACAORECEITA
			AND R.COVID19 = 'S'
           WHERE EX.ENTIDADE = RD.ENTIDADE 
             AND EX.EXERCICIO = RD.EXERCICIO 
             AND EX.MES = EXTRACT(MONTH FROM RD.DATA) 
             AND RD.DATA <= :diasRetroativo
             AND R.MOVSN = 'S') AS VALORARRECADADO,
	(SELECT COALESCE(SUM(FICHA.VALOR - FICHA.VALORANULACOES + FICHA.VALORESTANULACOES),0)
       FROM FICHAEMPENHO FICHA, EMPENHO E
	  WHERE E.ENTIDADE = FICHA.ENTIDADE
		AND E.EXERCICIO = FICHA.EXERCICIO
		AND E.EMPENHO = FICHA.EMPENHO
		AND E.UNIDADEORCAMENTARIA = FICHA.UNIDADEORCAMENTARIA
        AND E.MPCOVID19 = 'S'
		AND FICHA.DATA <= :diasRetroativo
        AND FICHA.ENTIDADE = EX.ENTIDADE
		AND FICHA.EXERCICIO = EX.EXERCICIO
        AND EXTRACT(MONTH FROM FICHA.DATA) = EX.MES) AS VALOREMPENHADO,  
    (SELECT COALESCE(SUM(FICHA.VALORLIQUIDACOES - FICHA.VALORESTLIQUIDACOES),0)
       FROM FICHAEMPENHO FICHA, EMPENHO E, LIQUIDACAO L
	  WHERE L.ENTIDADE = E.ENTIDADE
        AND L.ANODOCORIGEM = E.EXERCICIO
        AND L.NODOCORIGEM = E.EMPENHO
        AND L.UNIDADEDOCORIGEM = E.UNIDADEORCAMENTARIA
        AND E.ENTIDADE = FICHA.ENTIDADE
		AND E.EXERCICIO = FICHA.EXERCICIO
		AND E.EMPENHO = FICHA.EMPENHO
		AND E.UNIDADEORCAMENTARIA = FICHA.UNIDADEORCAMENTARIA
        AND E.MPCOVID19 = 'S'
		AND FICHA.DATA <= :diasRetroativo
        AND FICHA.ENTIDADE = EX.ENTIDADE
		AND FICHA.EXERCICIO = EX.EXERCICIO
        AND EXTRACT(MONTH FROM FICHA.DATA) = EX.MES) AS VALORLIQUIDADO,
	(SELECT COALESCE(SUM(FICHA.VALORPAGAMENTO - FICHA.VALORESTPAGAMENTO),0)
       FROM FICHAEMPENHO FICHA, EMPENHO E, LIQUIDACAO L, ORDEMPAGAMENTO_LIQUIDACAO OP, PAGAMENTO P
	  WHERE P.ENTIDADE = OP.ENTIDADE
   	    AND P.ANOORDEMPAGAMENTO = OP.EXERCICIO
	    AND P.NOORDEMPAGAMENTO = OP.NOORDEM
	    AND P.ESTORNO = 'N'
	    AND OP.ENTIDADE = L.ENTIDADE
	    AND OP.EXERCICIO = L.EXERCICIO
	    AND OP.NOLIQUIDACAO = L.NOLIQUIDACAO
	    AND OP.TIPODOCORIGEM = L.TIPODOCORIGEM
	    AND OP.ANODOCORIGEM = L.ANODOCORIGEM
	    AND OP.NODOCORIGEM = L.NODOCORIGEM
	    AND OP.UNIDADEDOCORIGEM = L.UNIDADEDOCORIGEM
	    AND L.ENTIDADE = E.ENTIDADE
        AND L.ANODOCORIGEM = E.EXERCICIO
        AND L.NODOCORIGEM = E.EMPENHO
        AND L.UNIDADEDOCORIGEM = E.UNIDADEORCAMENTARIA
        AND E.ENTIDADE = FICHA.ENTIDADE
		AND E.EXERCICIO = FICHA.EXERCICIO
		AND E.EMPENHO = FICHA.EMPENHO
		AND E.UNIDADEORCAMENTARIA = FICHA.UNIDADEORCAMENTARIA
        AND E.MPCOVID19 = 'S'
		AND FICHA.DATA <= :diasRetroativo
        AND FICHA.ENTIDADE = EX.ENTIDADE
		AND FICHA.EXERCICIO = EX.EXERCICIO
        AND EXTRACT(MONTH FROM FICHA.DATA) = EX.MES) AS VALORPAGO
 FROM EXERCICIO_MES EX 
 WHERE EX.ENTIDADE = :entidade
 AND EX.EXERCICIO = :exercicio
 ORDER BY EX.MES