SELECT P.NOME AS FORNECEDOR, 
       P.CNPJ_CPF AS CNPJCPF, 
       D.DESCRICAO AS TIPOCERTIDAO, 
       F.NUMERODOCUMENTO, 
       F.DATAEMISSAODOCUMENTO AS DATAEMISSAO, 
       F.VALIDADEDOCUMENTO AS DATAVALIDADE,
       CASE WHEN F.NOMEARQUIVO IS NULL THEN ELOARQ.NOME ELSE F.NOMEARQUIVO END AS NOMEARQUIVO,
       LENGTH(AC.ARQUIVO) AS TAMANHOARQUIVO,
       A.IDARQUIVO,
       A.DATA AS DATAARQUIVO
  FROM CLFORNECEDORDOCUMENTACAO F
 INNER JOIN CLLICITACAOFORNECEDOR LF
    ON LF.ENTIDADE = F.ENTIDADE
   AND LF.EXERCICIO = F.EXERCICIO
   AND LF.EXERCICIOLICITACAO = F.EXERCICIOLICITACAO
   AND LF.TIPOLICITACAO = F.TIPOLICITACAO
   AND LF.LICITACAO = F.LICITACAO
   AND LF.PESSOA = F.PESSOA
  JOIN CLDOCUMENTACAO D
    ON D.DOCUMENTACAO = F.DOCUMENTACAO
  JOIN PESSOA P
    ON P.PESSOA = F.PESSOA
  LEFT JOIN PESSOADOCUMENTACAO PD
    ON PD.PESSOA = F.PESSOA
   AND PD.DOCUMENTACAO = F.DOCUMENTACAO
   AND (PD.DATAEMISSAODOCUMENTO = F.DATAEMISSAODOCUMENTO OR F.DATAEMISSAODOCUMENTO IS NULL)
   AND (PD.VALIDADEDOCUMENTO = F.VALIDADEDOCUMENTO OR F.VALIDADEDOCUMENTO IS NULL)
   AND PD.NUMERODOCUMENTO = F.NUMERODOCUMENTO
  LEFT JOIN ARQUIVO A
    ON A.ID = PD.IDARQUIVO
  LEFT JOIN schema_eloarquivo.ARQUIVO ELOARQ
    ON ELOARQ.ID = A.IDARQUIVO
  LEFT JOIN schema_eloarquivo.ARQUIVO_CONTENT AC
    ON AC.ID = A.IDARQUIVO
 WHERE LF.COMPARECEU = 'S'
   AND F.ENTIDADE = :entidade
   AND F.EXERCICIOLICITACAO = :exercicio
   AND F.TIPOLICITACAO = :tipoLicitacao
   AND F.LICITACAO = :licitacao
 ORDER BY P.NOME, D.DESCRICAO
