/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.core.web.request.ContextHolder;
import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.domain.dto.EloPortalParametroTextoDTO;
import br.com.elotech.portaltransparencia.admportal.service.PortalParametroService;
import br.com.elotech.portaltransparencia.arquivoportal.domain.ArquivoInterface;
import br.com.elotech.portaltransparencia.contabportal.domain.Fornecedor;
import br.com.elotech.portaltransparencia.contabportal.domain.PortalParametroContabil;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.MenuDTO;
import br.com.elotech.portaltransparencia.contabportal.service.MenuService;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/parametros"})
public class PortalParametroResource {
    private final MenuService menuService;
    private final PortalParametroService portalParametroService;

    public PortalParametroResource(MenuService menuService, PortalParametroService portalParametroService) {
        this.menuService = menuService;
        this.portalParametroService = portalParametroService;
    }

    @GetMapping(value={"/menu/{entidade}/{exercicio}"})
    public ResponseEntity<List<MenuDTO>> getMenu(@PathVariable Long entidade, @PathVariable Long exercicio) {
        List menus = this.menuService.getMenu(entidade, exercicio);
        menus.stream().sorted((o1, o2) -> o1.getId().compareTo(o2.getId())).forEach(MenuDTO::orderSubmenus);
        return ResponseEntity.ok((Object)menus);
    }

    @GetMapping(value={"/{entidade}/{exercicio}"})
    public ResponseEntity<List<PortalParametroContabil>> getParametros(@PathVariable Long entidade, @PathVariable Long exercicio) {
        return ResponseEntity.ok(this.portalParametroService.getParametros(entidade, exercicio).stream().filter(parametro -> Parametros.getParametrosOcultos().stream().noneMatch(parametroOculto -> parametro.getIdParametro().equals(parametroOculto))).collect(Collectors.toList()));
    }

    @GetMapping(value={"/leiesic"})
    public ResponseEntity<ArquivoInterface> getLeiESic() {
        ArquivoInterface leieSIC = this.portalParametroService.getLeieSIC();
        if (Objects.nonNull(leieSIC)) {
            return ResponseEntity.ok((Object)leieSIC);
        }
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/instrucao-normativa/{entidade}/{exercicio}"})
    public ResponseEntity<ArquivoInterface> getInstrucaoNormativa(@PathVariable Long entidade, @PathVariable Long exercicio) {
        ArquivoInterface instrucaoNormativa = this.portalParametroService.getInstrucaoNormativa(entidade, exercicio);
        if (Objects.nonNull(instrucaoNormativa)) {
            return ResponseEntity.ok((Object)instrucaoNormativa);
        }
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/leiOrganicaMunicipio"})
    public ResponseEntity<ArquivoInterface> getLeiOrganicaMunicipio() {
        ArquivoInterface leiOrganicaMunicipio = this.portalParametroService.getLeiOrganicaMunicipio();
        if (Objects.nonNull(leiOrganicaMunicipio)) {
            return ResponseEntity.ok((Object)leiOrganicaMunicipio);
        }
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/medidas-adotadas-cobranca/{entidade}/{exercicio}"})
    public ResponseEntity<ArquivoInterface> getMedidasAdotadasCobranca(@PathVariable Long entidade, @PathVariable Long exercicio) {
        ArquivoInterface medidaAdotaCobranca = this.portalParametroService.getMedidasAdotadasCobranca(entidade, exercicio);
        if (Objects.nonNull(medidaAdotaCobranca)) {
            return ResponseEntity.ok((Object)medidaAdotaCobranca);
        }
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/manual-fornecedor"})
    public ResponseEntity<ArquivoInterface> getIdManualFornecedor() {
        ArquivoInterface arquivoManualFornecedor = this.portalParametroService.getManualFornecedor();
        if (Objects.nonNull(arquivoManualFornecedor)) {
            return ResponseEntity.ok((Object)arquivoManualFornecedor);
        }
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/sic-fisico"})
    public ResponseEntity<ArquivoInterface> getArquivoSicFisico() {
        ArquivoInterface arquivoSicFisico = this.portalParametroService.getArquivoSicFisico();
        if (Objects.nonNull(arquivoSicFisico)) {
            return ResponseEntity.ok((Object)arquivoSicFisico);
        }
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/sic-fisico/mensagem"})
    public ResponseEntity<EloPortalParametroTextoDTO> getMensagemSicFisico(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @RequestParam Long tipoCadastro) {
        return ResponseEntity.ok((Object)this.portalParametroService.getMensagemParametroTexto(entidade, exercicio, tipoCadastro));
    }

    @GetMapping(value={"/responsavel-lai"})
    public ResponseEntity<Fornecedor> findResponsavelLai() {
        return ResponseEntity.ok((Object)this.portalParametroService.findResponsavelLai(Long.valueOf(ContextHolder.getHeaderValueEntidade().longValue()), Long.valueOf(ContextHolder.getHeaderValueExercicio().longValue())));
    }
}

