/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.UltimaAtualizacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.UltimaAtualizacaoCustom;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class UltimaAtualizacaoRepository
implements UltimaAtualizacaoCustom {
    private final JdbcTemplate jdbcTemplate;

    @Autowired
    public UltimaAtualizacaoRepository(@Qualifier(value="dataSource") DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public List<UltimaAtualizacaoDTO> ultimaAtualizacao() {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT MODULO, MAX(ULTIMOACESSO) AS ULTIMOACESSO \n");
        sql.append("  FROM USRXMOD \n");
        sql.append(" WHERE ULTIMOACESSO IS NOT NULL \n");
        sql.append(" GROUP BY MODULO");
        return this.jdbcTemplate.query(sql.toString(), (RowMapper)new ElotechBeanPropertyRowMapper(UltimaAtualizacaoDTO.class));
    }

    public UltimaAtualizacaoDTO getUltimaAtualizacao(String table, String column, Long entidade) {
        List listResult = this.jdbcTemplate.query(SqlUtils.createSQLUltimaAtualizacaoByTableAndColumn((String)table, (String)column, (Long)entidade), (RowMapper)new ElotechBeanPropertyRowMapper(UltimaAtualizacaoDTO.class));
        return listResult.stream().findFirst().orElse(new UltimaAtualizacaoDTO());
    }
}

