/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.portaltransparencia.contabportal.domain.FichaEmpenhoPK;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="FICHAEMPENHO")
public class FichaEmpenho
implements EloEntity<FichaEmpenhoPK> {
    @EmbeddedId
    private FichaEmpenhoPK id;
    @Column(name="VALOR", precision=2)
    private BigDecimal valor;
    @Column(name="VALORANULACOES", precision=2)
    private BigDecimal valorAnulacoes;
    @Column(name="VALORESTANULACOES", precision=2)
    private BigDecimal valorEstAnulacoes;
    @Column(name="VALORLIQUIDACOES", precision=2)
    private BigDecimal valorLiquidacoes;
    @Column(name="VALORESTLIQUIDACOES", precision=2)
    private BigDecimal valorEstLiquidacoes;
    @Column(name="VALORRETENCOES", precision=2)
    private BigDecimal valorRetencoes;
    @Column(name="VALORPAGAMENTO", precision=2)
    private BigDecimal valorPagamento;
    @Column(name="VALORESTPAGAMENTO", precision=2)
    private BigDecimal valorEstPagamento;

    public BigDecimal getValor() {
        if (Objects.nonNull(this.valor)) {
            return this.valor;
        }
        return BigDecimal.ZERO;
    }

    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    public BigDecimal getValorAnulacoes() {
        if (Objects.nonNull(this.valorAnulacoes)) {
            return this.valorAnulacoes;
        }
        return BigDecimal.ZERO;
    }

    public void setValorAnulacoes(BigDecimal valorAnulacoes) {
        this.valorAnulacoes = valorAnulacoes;
    }

    public BigDecimal getValorEstAnulacoes() {
        if (Objects.nonNull(this.valorEstAnulacoes)) {
            return this.valorEstAnulacoes;
        }
        return BigDecimal.ZERO;
    }

    public void setValorEstAnulacoes(BigDecimal valorEstAnulacoes) {
        this.valorEstAnulacoes = valorEstAnulacoes;
    }

    public BigDecimal getValorLiquidacoes() {
        if (Objects.nonNull(this.valorLiquidacoes)) {
            return this.valorLiquidacoes;
        }
        return BigDecimal.ZERO;
    }

    public void setValorLiquidacoes(BigDecimal valorLiquidacoes) {
        this.valorLiquidacoes = valorLiquidacoes;
    }

    public BigDecimal getValorEstLiquidacoes() {
        if (Objects.nonNull(this.valorEstLiquidacoes)) {
            return this.valorEstLiquidacoes;
        }
        return BigDecimal.ZERO;
    }

    public void setValorEstLiquidacoes(BigDecimal valorEstLiquidacoes) {
        this.valorEstLiquidacoes = valorEstLiquidacoes;
    }

    public BigDecimal getValorRetencoes() {
        if (Objects.nonNull(this.valorRetencoes)) {
            return this.valorRetencoes;
        }
        return BigDecimal.ZERO;
    }

    public void setValorRetencoes(BigDecimal valorRetencoes) {
        this.valorRetencoes = valorRetencoes;
    }

    public BigDecimal getValorPagamento() {
        if (Objects.nonNull(this.valorPagamento)) {
            return this.valorPagamento;
        }
        return BigDecimal.ZERO;
    }

    public void setValorPagamento(BigDecimal valorPagamento) {
        this.valorPagamento = valorPagamento;
    }

    public BigDecimal getValorEstPagamento() {
        if (Objects.nonNull(this.valorEstPagamento)) {
            return this.valorEstPagamento;
        }
        return BigDecimal.ZERO;
    }

    public void setValorEstPagamento(BigDecimal valorEstPagamento) {
        this.valorEstPagamento = valorEstPagamento;
    }

    public BigDecimal calcularValorAnulado() {
        return this.getValorAnulacoes().subtract(this.getValorEstAnulacoes());
    }

    public BigDecimal calcularValorLiquidado() {
        return this.getValorLiquidacoes().subtract(this.getValorEstLiquidacoes());
    }

    public BigDecimal calcularValorPago() {
        return this.getValorPagamento().subtract(this.getValorEstPagamento());
    }

    public BigDecimal calcularValorAPagar() {
        return this.getValor().subtract(this.calcularValorAnulado()).subtract(this.getValorRetencoes()).subtract(this.calcularValorPago());
    }

    public FichaEmpenhoPK getId() {
        return this.id;
    }

    public void setId(FichaEmpenhoPK id) {
        this.id = id;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FichaEmpenho)) {
            return false;
        }
        FichaEmpenho other = (FichaEmpenho)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        FichaEmpenhoPK this$id = this.getId();
        FichaEmpenhoPK other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FichaEmpenho;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FichaEmpenhoPK $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

