SELECT row_number() OVER (PARTITION BY XX.FONTERECURSO ORDER BY XX.FONTERECURSO, XX.DATA, XX.EMPENHO, XX.EXERCICIO) AS ORDEMFONTERECURSO, XX.*
  FROM (
SELECT FR.FONTERECURSO || ' - ' || FR.DESCRICAO AS FONTERECURSO,
       L.DATA,
       O.VENCIMENTO DATAVENCIMENTO,
       P.DATA DATAPAGAMENTO,
       L.EXERCICIO AS EXERCICIOLIQUIDACAO,
       L.NOLIQUIDACAO,
       E.EMPENHO || '/' || E.EXERCICIO AS EMPENHOEXERCICIO,
       E.ENTIDADE,
       E.EXERCICIO,
       E.EMPENHO,
       E.UNIDADEORCAMENTARIA,
       TL.DESCRICAO AS TIPOLICITACAO,
       E.NOLICITACAO || '/' || E.ANOLICITACAO AS LICITACAO,
       CASE WHEN F.TIPOPESSOA = 'F' THEN '****' || SUBSTR(F.CNPJ, 5, 3) || '****' || ' - ' || F.NOME 
			ELSE SUBSTR(F.CNPJ,1,2) || '.' || SUBSTR(F.CNPJ,3,3) || '.' || SUBSTR(F.CNPJ,6,3) || '/' || SUBSTR(F.CNPJ,9,4) || '-' || SUBSTR(F.CNPJ,13,2) || ' - ' || F.NOME 
	   END AS FORNECEDOR,
       OL.NOORDEM,
       OL.SEQUENCIA,
       L.VALOR AS VALOR,
	   (L.VALOR - L.VALORRETENCOES -
       (SELECT COALESCE(SUM(EL.VALOR), 0)
          FROM ESTORNOLIQUIDACAO EL
         WHERE EL.ENTIDADE = L.ENTIDADE
           AND EL.EXERCICIOLIQ = L.EXERCICIO
           AND EL.TIPODOCORIGEM = L.TIPODOCORIGEM
           AND EL.ANODOCORIGEM = L.ANODOCORIGEM
           AND EL.NODOCORIGEM = L.NODOCORIGEM
           AND EL.UNIDADEDOCORIGEM = L.UNIDADEDOCORIGEM
           AND EL.NOLIQUIDACAO = L.NOLIQUIDACAO) -
       (SELECT COALESCE(SUM(CR.VALOR), 0)
          FROM CANCELAMENTORESTOS CR
         WHERE CR.ENTIDADE = L.ENTIDADE
           AND CR.EXERCICIO = L.ANODOCORIGEM
           AND CR.EMPENHO = L.NODOCORIGEM
           AND CR.UNIDADEORCAMENTARIA = L.UNIDADEDOCORIGEM) -
       (SELECT COALESCE(SUM(OPL.VALOR), 0)
          FROM ORDEMPAGAMENTO_LIQUIDACAO OPL
          JOIN ORDEMPAGAMENTO OP 
            ON OP.ENTIDADE  = OPL.ENTIDADE
           AND OP.EXERCICIO = OPL.EXERCICIO
           AND OP.NOORDEM   = OPL.NOORDEM
           AND OP.CANCELADO = 'P'
         WHERE OPL.ENTIDADE = L.ENTIDADE
           AND OPL.EXERCICIOLIQ  = L.EXERCICIO
           AND OPL.TIPODOCORIGEM = L.TIPODOCORIGEM
           AND OPL.ANODOCORIGEM  = L.ANODOCORIGEM
           AND OPL.NODOCORIGEM   = L.NODOCORIGEM
           AND OPL.UNIDADEDOCORIGEM = L.UNIDADEDOCORIGEM
           AND OPL.NOLIQUIDACAO = L.NOLIQUIDACAO) -
       (SELECT COALESCE(SUM(R.VALOR), 0)
          FROM ORDEMPAGAMENTO_RETENCAO R
          JOIN ORDEMPAGAMENTO OP
            ON OP.ENTIDADE  = R.ENTIDADE
           AND OP.EXERCICIO = R.EXERCICIO
           AND OP.NOORDEM   = R.NOORDEM
           AND OP.CANCELADO = 'P'
         WHERE R.ENTIDADE   = L.ENTIDADE
           AND R.EXERCICIOLIQ  = L.EXERCICIO
           AND R.TIPODOCORIGEM = L.TIPODOCORIGEM
           AND R.ANODOCORIGEM  = L.ANODOCORIGEM
           AND R.NODOCORIGEM   = L.NODOCORIGEM
           AND R.UNIDADEDOCORIGEM = L.UNIDADEDOCORIGEM
           AND R.NOLIQUIDACAO  = L.NOLIQUIDACAO)) AS SALDO,
           O.CANCELADO
  FROM LIQUIDACAO L
  LEFT JOIN EMPENHO E 
    ON E.ENTIDADE  = L.ENTIDADE
   AND E.EXERCICIO = L.ANODOCORIGEM
   AND E.EMPENHO   = L.NODOCORIGEM
   AND E.UNIDADEORCAMENTARIA = L.UNIDADEDOCORIGEM
   AND E.CONTABILIZADO = 'S'
  LEFT JOIN FONTERECURSO FR 
    ON E.FONTERECURSO = FR.FONTERECURSO
  LEFT JOIN TIPOSLICITACAO TL 
    ON E.TIPOLICITACAO = TL.TIPOLICITACAO
  LEFT JOIN FORNECEDOR F 
    ON E.FORNECEDOR = F.FORNECEDOR
  LEFT JOIN ORDEMPAGAMENTO_LIQUIDACAO OL
    ON OL.ENTIDADE      = L.ENTIDADE
   AND OL.EXERCICIOLIQ  = L.EXERCICIO
   AND OL.TIPODOCORIGEM = L.TIPODOCORIGEM
   AND OL.ANODOCORIGEM  = L.ANODOCORIGEM
   AND OL.NODOCORIGEM   = L.NODOCORIGEM
   AND OL.UNIDADEDOCORIGEM = L.UNIDADEDOCORIGEM
   AND OL.NOLIQUIDACAO  = L.NOLIQUIDACAO
  LEFT JOIN ORDEMPAGAMENTO O
    ON O.ENTIDADE  = OL.ENTIDADE
   AND O.EXERCICIO = OL.EXERCICIO
   AND O.NOORDEM   = OL.NOORDEM
  LEFT JOIN PAGAMENTO P
    ON P.ENTIDADE          = O.ENTIDADE
   AND P.ANOORDEMPAGAMENTO = O.EXERCICIO
   AND P.NOORDEMPAGAMENTO  = O.NOORDEM
  $[FILTRO]
       ) XX 
  $[WHERE]
  (((XX.EXERCICIOLIQUIDACAO <= 2013) AND 
        (NOT EXISTS (SELECT C.EMPENHO
                       FROM CANCELAMENTORESTOS C
                      WHERE C.ENTIDADE   = XX.ENTIDADE
                        AND C.EXERCICIO  = XX.EXERCICIO
                        AND C.EMPENHO    = XX.EMPENHO
                        AND C.UNIDADEORCAMENTARIA = XX.UNIDADEORCAMENTARIA
                        AND C.FLAGAPROCESSAR = 'N'))) OR (XX.EXERCICIOLIQUIDACAO > 2013))
   AND EXISTS (SELECT X.ENTIDADE, X.EXERCICIO, X.EMPENHO, X.UNIDADEORCAMENTARIA
                 FROM (SELECT E.ENTIDADE,
                              E.EXERCICIO,
                              E.EMPENHO,
                              E.UNIDADEORCAMENTARIA,
                              SUM(FE.VALOR) AS EMPENHADO,
                              SUM(FE.VALORANULACOES - FE.VALORESTANULACOES) AS ANULADO,
                              SUM(FE.VALORRETENCOES) AS RETIDO,
                              SUM(FE.VALORPAGAMENTO - FE.VALORESTPAGAMENTO) AS PAGO
                         FROM EMPENHO E
                         LEFT OUTER JOIN FICHAEMPENHO FE 
                           ON E.ENTIDADE  = FE.ENTIDADE
                          AND E.EXERCICIO = FE.EXERCICIO
                          AND E.EMPENHO   = FE.EMPENHO
                          AND E.UNIDADEORCAMENTARIA = FE.UNIDADEORCAMENTARIA
                        WHERE E.CONTABILIZADO = 'S'
                        GROUP BY E.ENTIDADE, E.EXERCICIO, E.EMPENHO, E.UNIDADEORCAMENTARIA) X
                WHERE X.ENTIDADE  = XX.ENTIDADE
                  AND X.EXERCICIO = XX.EXERCICIO
                  AND X.EMPENHO   = XX.EMPENHO
                  AND X.UNIDADEORCAMENTARIA = XX.UNIDADEORCAMENTARIA)