/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.saude.service;

import br.com.elotech.portaltransparencia.contabportal.domain.dto.UltimaAtualizacaoDTO;
import java.net.URI;
import java.util.Arrays;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class UltimaAtualizacaoSaudeService {
    private final RestTemplate restTemplate;
    @Value(value="${elotech.sistemaSaude.url:}")
    private String urlSaude;
    @Value(value="${elotech.sistemaSaude.enabled:false}")
    private Boolean sistemaSaude;

    public UltimaAtualizacaoSaudeService(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public UltimaAtualizacaoDTO getUltimaAtualizacao(String tabela) {
        if (Boolean.FALSE.equals(this.sistemaSaude) || this.urlSaude.isEmpty()) {
            return new UltimaAtualizacaoDTO();
        }
        URI uri = URI.create(String.format("%s/WebSocialSaude/rest/saude/ultima-atualizacao/%s", this.urlSaude, tabela));
        RequestEntity requestEntity = RequestEntity.get((URI)uri).build();
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(requestEntity, UltimaAtualizacaoDTO[].class);
            return (UltimaAtualizacaoDTO)Arrays.asList((Object[])Objects.requireNonNull(responseEntity.getBody())).get(0);
        }
        catch (HttpClientErrorException e) {
            return new UltimaAtualizacaoDTO();
        }
    }
}

