/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindExercicioParams;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ConsumoPorCentroCustroDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ItemEstoqueDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.OrgaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.UltimaAtualizacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.portaltransparencia.contabportal.service.ItemEstoqueService;
import br.com.elotech.portaltransparencia.web.rest.params.ConsumoPorCentroCustoParams;
import br.com.elotech.portaltransparencia.web.rest.params.ItemEstoqueParams;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import java.math.BigDecimal;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/estoque"})
public class ItemEstoqueResource {
    private final ItemEstoqueService itemEstoqueService;
    private final BaseExport baseExport;
    private final ElotechProperties elotechProperties;
    private final EntidadeContabilidadeRepository entidadeRepository;

    public ItemEstoqueResource(ItemEstoqueService itemEstoqueService, BaseExport baseExport, ElotechProperties elotechProperties, EntidadeContabilidadeRepository entidadeRepository) {
        this.baseExport = baseExport;
        this.elotechProperties = elotechProperties;
        this.entidadeRepository = entidadeRepository;
        this.itemEstoqueService = itemEstoqueService;
    }

    @GetMapping(params={"entidade", "orgao"})
    public ResponseEntity<Page<ItemEstoqueDTO>> findItemEstoque(ItemEstoqueParams params, Pageable pageable) {
        return ResponseEntity.ok((Object)this.itemEstoqueService.findItemEstoque(params, pageable));
    }

    @GetMapping(value={"/orgao"})
    public ResponseEntity<List<OrgaoDTO>> findOrgao(FindExercicioParams params) {
        return ResponseEntity.ok((Object)this.itemEstoqueService.findOrgao(params));
    }

    @RequestMapping(value={"/report"})
    public ModelAndView findItemEstoqueExport(HttpServletRequest request, HttpServletResponse response, ItemEstoqueParams params, Pageable pageable) throws Throwable {
        PageRequest pageRequest = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros(), (Sort)pageable.getSort());
        Page page = this.itemEstoqueService.findItemEstoque(params, (Pageable)pageRequest);
        Entidade entidadeObj = (Entidade)this.entidadeRepository.findOne((Object)params.getEntidade());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setReportTitle("Listagem Almoxarifado");
        reportParam.setClazzDTO(ItemEstoqueDTO.class);
        reportParam.setHeaderFields("C\u00f3digo,Descri\u00e7\u00e3o,Unidade,Saldo,Custo Unit\u00e1rio,Valor Total");
        reportParam.setFields("item,itemDescricao,unidade,saldo,custoUnitario,valorTotal");
        float[] fieldsPerc = new float[]{1.0f, 4.5f, 1.5f, 1.0f, 1.0f, 1.0f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{20, 500, 30, 20, 20, 20};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setPage(page);
        reportParam.setFontSize(6.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }

    @GetMapping(value={"/ultimas-atualizacoes"})
    public ResponseEntity<List<UltimaAtualizacaoDTO>> findUltimaAtualizacao(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, FindExercicioParams params) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.itemEstoqueService.findUltimaAtualizacao(params));
    }

    @GetMapping(value={"/consumo"}, params={"entidade", "exercicio", "centroCustoOrigem", "centroCustoDestino", "dataInicio", "dataFinal"})
    public ResponseEntity<Page<ConsumoPorCentroCustroDTO>> findItensConsumo(ConsumoPorCentroCustoParams params, Pageable pageable) {
        return ResponseEntity.ok((Object)this.itemEstoqueService.findItensConsumo(params, pageable));
    }

    @GetMapping(value={"/consumo/total"}, params={"entidade", "exercicio", "centroCustoOrigem", "centroCustoDestino", "dataInicio", "dataFinal"})
    public ResponseEntity<BigDecimal> findTotalConsumido(ConsumoPorCentroCustoParams params) {
        return ResponseEntity.ok((Object)this.itemEstoqueService.findTotalConsumido(params));
    }
}

