SELECT *
  FROM
(SELECT F.ENTIDADE,  
      TRIM(P.NOME) AS NOME,  
      P.CNPJ_CPF,
      F.MATRICULA,  
      SF.SITUACAO,
      F.DATAADMISSAO,
      CASE WHEN F.SITUACAO = 3 AND F.DATASITUACAO <= :dataAtual THEN F.DATASITUACAO ELSE NULL END AS DATADEMISSAO,
      (SELECT COALESCE(MAX(CARGOMOV.DESCRICAO), C.DESCRICAO) 
         FROM RHMOVIMENTACAOPESSOAL MP 
         LEFT OUTER JOIN RHMOVIMENTACAOOUTROS MO 
           ON MP.MOVIMENTACAO = MO.MOVIMENTACAO
          AND MP.ENTIDADE = MO.ENTIDADE
          AND MP.MATRICULA = MO.MATRICULA
         LEFT OUTER JOIN RHCARGO CARGOMOV 
           ON MO.ENTIDADE = CARGOMOV.ENTIDADE 
          AND MO.CARGO = CARGOMOV.CARGO 
        WHERE MP.MATRICULA = F.MATRICULA 
          AND MP.ENTIDADE = F.ENTIDADE
          AND MP.TIPOMOVIMENTACAO IN (59, 99)
          AND ((MO.DATAFIM IS NULL) OR (MO.DATAFIM >= :dataAtual))
          AND EXTRACT(YEAR FROM MO.DATAINICIO) <= :exercicio
      ) AS DESCRICAOCARGO,  
      CL.DESCRICAO AS DESCRICAOCLASSE,  
      RDC.DESCRICAO AS DESCRICAONATUREZA,
      RDC.DEFINICAO,
      COALESCE(RLD.DESCRICAO, RL.DESCRICAO) AS DESCRICAOLOTACAO,
      COALESCE(HF.FAIXA, F.FAIXA) FAIXA,
      LOCALTRAB.DESCRICAO AS LOCALTRABALHO,
      HOR.ENTRADA AS HORARIOENTRADA,
      HOR.SAIDAINTERVALO AS HORARIOSAIDAINTERVALO,
      HOR.ENTRADAINTERVALO AS HORARIOENTRADAINTERVALO,
      HOR.SAIDA AS HORARIOSAIDA,
      HOR.PERMITEFLEXIBILIDADE AS HORARIOESPECIAL,
  (SELECT COALESCE(MAX(CN.DESCRICAO || ' - ' || COALESCE(FC.FAIXA, '')),
                   MAX(FC.DESCRICAO || ' - ' || COALESCE(FC.FAIXA, ''))) 
     FROM RHMOVIMENTACAOPESSOAL MP
    JOIN RHTIPOMOVIMENTACAO TM
      ON MP.TIPOMOVIMENTACAO = TM.TIPOMOVIMENTACAO
    JOIN RHMOVIMENTACAOOUTROS MO
      ON MP.ENTIDADE = MO.ENTIDADE
     AND MP.MATRICULA = MO.MATRICULA
     AND MP.MOVIMENTACAO = MO.MOVIMENTACAO
    LEFT OUTER JOIN RHCARGO CN
      ON CN.ENTIDADE = MO.ENTIDADE
     AND CN.CARGO = MO.CARGO
    LEFT OUTER JOIN RHFUNCAO FC
      ON MO.ENTIDADE = FC.ENTIDADE
     AND MO.FUNCAO = FC.FUNCAO
    WHERE F.ENTIDADE = MP.ENTIDADE
      AND F.MATRICULA = MP.MATRICULA
      AND (((MP.TIPOMOVIMENTACAO IN (59, 60, 102))
           AND (MO.OPCAOSALARIO IN ('N', 'D', 'C')))
              OR (MP.TIPOMOVIMENTACAO IN (45, 58, 99)))
               AND (MO.OPCAOSALARIO IS NULL OR MO.OPCAOSALARIO <> 'O')
      AND ((MO.DATAFIM IS NULL) OR (MO.DATAFIM > :dataAtual))
   ) NOMEACAO,
   (SELECT MAX(CASE WHEN ML.TIPOBENEFICIO = 'N' THEN 'CEDIDO SEM ÔNUS - ' || Coalesce(P.NOME,' ')
        ELSE 'CEDIDO COM ÔNUS - ' || Coalesce(P.NOME,' ') END)
     FROM RHMOVIMENTACAOPESSOAL MP
     JOIN RHTIPOMOVIMENTACAO TM
       ON MP.TIPOMOVIMENTACAO = TM.TIPOMOVIMENTACAO
     JOIN RHMOVIMENTACAOLEGAL ML
       ON MP.ENTIDADE = ML.ENTIDADE
      AND MP.MATRICULA = ML.MATRICULA
      AND MP.MOVIMENTACAO = ML.MOVIMENTACAO
     LEFT OUTER JOIN PESSOA P
       ON ML.PESSOA = P.PESSOA
    WHERE F.ENTIDADE = MP.ENTIDADE
      AND F.MATRICULA = MP.MATRICULA
      AND MP.TIPOMOVIMENTACAO = 90
     AND ((ML.DATATERMINO IS NULL) OR (ML.DATATERMINO > :dataAtual))
   ) CEDIDO,
   (SELECT MAX(CASE WHEN MA.TIPO = '6' THEN 'CEDIDO SEM ÔNUS - ' || Coalesce(P.NOME,' ')
     ELSE 'CEDIDO COM ÔNUS - ' || Coalesce(P.NOME,' ') END)
     FROM RHMOVIMENTACAOPESSOAL MP
     JOIN RHTIPOMOVIMENTACAO TM
       ON MP.TIPOMOVIMENTACAO = TM.TIPOMOVIMENTACAO
     JOIN RHMOVIMENTACAOAFASTAMENTO MA
       ON MP.ENTIDADE = MA.ENTIDADE
      AND MP.MATRICULA = MA.MATRICULA
      AND MP.MOVIMENTACAO = MA.MOVIMENTACAO
     LEFT OUTER JOIN PESSOA P
       ON MA.PESSOA = P.PESSOA
    WHERE F.ENTIDADE = MP.ENTIDADE
      AND F.MATRICULA = MP.MATRICULA
      AND MP.TIPOMOVIMENTACAO = 23
      AND ((MA.DATAFINAL IS NULL) OR (MA.DATAFINAL > :dataAtual))
   ) CEDIDOPARA,
   F.ADMISSAOEXCEPCIONAL
   FROM RHFUNCIONARIO F  
   LEFT OUTER JOIN RHHISTORICOFUNCIONARIO HF
     ON F.ENTIDADE = HF.ENTIDADE
    AND F.MATRICULA = HF.MATRICULA
    AND HF.TIPOFOLHA = FNC_GETTIPOFOLHAPRINCIPAL(F.ENTIDADE)
    AND HF.ANOCOMPETENCIA = :exercicio
    AND HF.MESCOMPETENCIA = 12
   LEFT OUTER JOIN PESSOA  P   
     ON F.PESSOA = P.PESSOA  
   LEFT OUTER JOIN VW_SITUACAOFUNCIONARIO SF
     ON F.ENTIDADE = SF.ENTIDADE
     AND F.MATRICULA = SF.MATRICULA
   LEFT OUTER JOIN RHCARGO C   
     ON F.ENTIDADE = C.ENTIDADE     
    AND COALESCE(HF.CARGO, F.CARGO) = C.CARGO    
   LEFT OUTER JOIN RHCLASSE CL   
     ON F.ENTIDADE = CL.ENTIDADE     
    AND COALESCE(HF.CLASSE, F.CLASSE) = CL.CLASSE    
   LEFT OUTER JOIN RHDEFINICAOCLASSE RDC       
     ON CL.DEFINICAO = RDC.DEFINICAO     
   LEFT OUTER JOIN RHLOTACAO RL       
     ON F.ENTIDADE = RL.ENTIDADE      
    AND COALESCE(HF.MODELOLOTACAO, F.MODELOLOTACAO) = RL.MODELOLOTACAO      
    AND COALESCE(HF.NIVELLOTACAO, F.NIVELLOTACAO) = RL.NIVELLOTACAO      
    AND COALESCE(HF.LOTACAO, F.LOTACAO) = RL.LOTACAO  
   LEFT OUTER JOIN RHMODELOLOTACAO ML
     ON COALESCE(HF.MODELOLOTACAO, F.MODELOLOTACAO) = ML.MODELOLOTACAO
   LEFT OUTER JOIN RHNIVELMODELOLOTACAO NML
     ON ML.MODELOLOTACAO = NML.MODELOLOTACAO
    AND ML.NIVELDESCRICAOPORTALTRANSP = NML.NIVELLOTACAO
   LEFT OUTER JOIN RHLOTACAO RLD
     ON F.ENTIDADE = RLD.ENTIDADE
    AND COALESCE(HF.MODELOLOTACAO, F.MODELOLOTACAO) = RLD.MODELOLOTACAO
    AND NML.NIVELLOTACAO = RLD.NIVELLOTACAO
    AND COALESCE(HF.NIVELLOTACAO, F.NIVELLOTACAO) > NML.NIVELLOTACAO
    AND RLD.LOTACAO = SUBSTR(COALESCE(HF.LOTACAO, F.LOTACAO), 1, (NML.POSICAO + NML.TAMANHO) - 1)
  LEFT OUTER JOIN RHLOCALDETRABALHO LOCALTRAB
    ON COALESCE(HF.LOCALDETRABALHO, F.LOCALDETRABALHO) = LOCALTRAB.LOCALDETRABALHO
  LEFT OUTER JOIN RHHORARIOTRABALHO HOR
    ON F.ENTIDADE = HOR.ENTIDADE
   AND COALESCE(HF.HORARIOTRABALHO, F.HORARIOTRABALHO) = HOR.HORARIOTRABALHO
  WHERE ((F.SITUACAO <> 3) OR (F.SITUACAO = 3 AND F.DATASITUACAO >= INICIOCOMPETENCIA(:exercicio,01)))
    AND NOT EXISTS ( 
            SELECT MP.MATRICULA
              FROM RHMOVIMENTACAOPESSOAL MP
             WHERE MP.MATRICULA = F.MATRICULA
               AND MP.ENTIDADE = F.ENTIDADE
               AND MP.TIPOMOVIMENTACAO IN (39, 67)
         )
    AND EXTRACT(YEAR FROM F.DATAADMISSAO) <= :exercicio
	AND :exercicio >= :exibirapartirde) XX
  WHERE ((XX.ENTIDADE = :entidade) OR (:unificadados = 'S'))
